/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.util.Set;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.ExceptionMethod;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class JpaLazyGetterFieldCheck<T>
implements FieldCheck<T> {
    private final Class<T> type;
    private final ClassAccessor<T> accessor;
    private final Set<String> ignoredFields;
    private final PrefabValues prefabValues;
    private final AnnotationCache annotationCache;

    public JpaLazyGetterFieldCheck(Configuration<T> config) {
        this.type = config.getType();
        this.accessor = config.getClassAccessor();
        this.ignoredFields = config.getIgnoredFields();
        this.prefabValues = config.getPrefabValues();
        this.annotationCache = config.getAnnotationCache();
    }

    @Override
    public void execute(ObjectAccessor<T> referenceAccessor, ObjectAccessor<T> copyAccessor, FieldAccessor fieldAccessor) {
        String fieldName = fieldAccessor.getFieldName();
        String getterName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        if (this.ignoredFields.contains(fieldName) || !this.fieldIsLazy(fieldAccessor)) {
            return;
        }
        this.assertEntity(fieldName, "equals", getterName, this.accessor.hasMethod(getterName, new Class[0]));
        ClassAccessor<T> subAccessor = this.throwingGetterAccessor(getterName);
        T red1 = subAccessor.getRedObject(TypeTag.NULL);
        T red2 = subAccessor.getRedObject(TypeTag.NULL);
        boolean equalsExceptionCaught = false;
        try {
            red1.equals(red2);
        }
        catch (EqualsVerifierInternalBugException e) {
            equalsExceptionCaught = true;
        }
        this.assertEntity(fieldName, "equals", getterName, equalsExceptionCaught);
        boolean hashCodeExceptionCaught = false;
        try {
            red1.hashCode();
        }
        catch (EqualsVerifierInternalBugException e) {
            hashCodeExceptionCaught = true;
        }
        this.assertEntity(fieldName, "hashCode", getterName, hashCodeExceptionCaught);
    }

    private boolean fieldIsLazy(FieldAccessor fieldAccessor) {
        return this.annotationCache.hasFieldAnnotation(this.type, fieldAccessor.getFieldName(), SupportedAnnotations.LAZY_FIELD);
    }

    private ClassAccessor<T> throwingGetterAccessor(String getterName) {
        Class<T> sub = Instantiator.giveDynamicSubclass(this.type, getterName, builder -> builder.method(ElementMatchers.named(getterName)).intercept(ExceptionMethod.throwing(EqualsVerifierInternalBugException.class)));
        return ClassAccessor.of(sub, this.prefabValues);
    }

    private void assertEntity(String fieldName, String method, String getterName, boolean assertion) {
        Assert.assertTrue(Formatter.of("JPA Entity: direct reference to field %% used in %% instead of getter %%.", fieldName, method, getterName), assertion);
    }
}

