/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.api;

import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.api.SingleTypeEqualsVerifierApi;
import nl.jqno.equalsverifier.internal.util.ListBuilders;
import nl.jqno.equalsverifier.internal.util.Validations;

public class RelaxedEqualsVerifierApi<T> {
    private final Class<T> type;
    private final List<T> equalExamples;

    public RelaxedEqualsVerifierApi(Class<T> type, List<T> examples) {
        this.type = type;
        this.equalExamples = Collections.unmodifiableList(examples);
    }

    public SingleTypeEqualsVerifierApi<T> andUnequalExample(T example) {
        return this.andUnequalExamples(example, new Object[0]);
    }

    @SafeVarargs
    public final SingleTypeEqualsVerifierApi<T> andUnequalExamples(T first, T ... more) {
        List<T> unequalExamples = ListBuilders.buildListOfAtLeastOne(first, more);
        Validations.validateUnequalExamples(unequalExamples, this.equalExamples);
        return new SingleTypeEqualsVerifierApi<T>(this.type, this.equalExamples, unequalExamples).suppress(new Warning[]{Warning.ALL_FIELDS_SHOULD_BE_USED});
    }
}

