/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;

public class SignificantFieldCheck<T>
implements FieldCheck<T> {
    private final Class<T> type;
    private final TypeTag typeTag;
    private final PrefabValues prefabValues;
    private final EnumSet<Warning> warningsToSuppress;
    private final Set<String> ignoredFields;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;
    private final AnnotationCache annotationCache;
    private final Predicate<FieldAccessor> isCachedHashCodeField;
    private final boolean skipCertainTestsThatDontMatterWhenValuesAreNull;

    public SignificantFieldCheck(Configuration<T> config, Predicate<FieldAccessor> isCachedHashCodeField, boolean skipCertainTestsThatDontMatterWhenValuesAreNull) {
        this.type = config.getType();
        this.typeTag = config.getTypeTag();
        this.prefabValues = config.getPrefabValues();
        this.warningsToSuppress = config.getWarningsToSuppress();
        this.ignoredFields = config.getIgnoredFields();
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
        this.annotationCache = config.getAnnotationCache();
        this.isCachedHashCodeField = isCachedHashCodeField;
        this.skipCertainTestsThatDontMatterWhenValuesAreNull = skipCertainTestsThatDontMatterWhenValuesAreNull;
    }

    @Override
    public void execute(ObjectAccessor<T> referenceAccessor, ObjectAccessor<T> copyAccessor, FieldAccessor fieldAccessor) {
        if (this.isCachedHashCodeField.test(fieldAccessor)) {
            return;
        }
        Field field = fieldAccessor.getField();
        T reference = referenceAccessor.get();
        T copy = copyAccessor.get();
        String fieldName = field.getName();
        boolean equalToItself = reference.equals(copy);
        T changed = copyAccessor.withChangedField(field, this.prefabValues, this.typeTag).get();
        boolean equalsChanged = !reference.equals(changed);
        boolean hashCodeChanged = this.cachedHashCodeInitializer.getInitializedHashCode(reference) != this.cachedHashCodeInitializer.getInitializedHashCode(changed);
        this.assertEqualsAndHashCodeRelyOnSameFields(equalsChanged, hashCodeChanged, reference, changed, fieldName);
        this.assertFieldShouldBeIgnored(equalToItself, equalsChanged, referenceAccessor.get(), fieldAccessor, fieldName);
        referenceAccessor.withChangedField(field, this.prefabValues, this.typeTag);
    }

    private void assertEqualsAndHashCodeRelyOnSameFields(boolean equalsChanged, boolean hashCodeChanged, T reference, T changed, String fieldName) {
        if (equalsChanged != hashCodeChanged) {
            Formatter formatter;
            boolean skipEqualsHasMoreThanHashCodeTest;
            boolean bl = skipEqualsHasMoreThanHashCodeTest = this.warningsToSuppress.contains((Object)Warning.STRICT_HASHCODE) || this.skipCertainTestsThatDontMatterWhenValuesAreNull;
            if (!skipEqualsHasMoreThanHashCodeTest) {
                formatter = Formatter.of("Significant fields: equals relies on %%, but hashCode does not.\n  %% has hashCode %%\n  %% has hashCode %%", fieldName, reference, reference.hashCode(), changed, changed.hashCode());
                Assert.assertFalse(formatter, equalsChanged);
            }
            formatter = Formatter.of("Significant fields: hashCode relies on %%, but equals does not.\nThese objects are equal, but probably shouldn't be:\n  %%\nand\n  %%", fieldName, reference, changed);
            Assert.assertFalse(formatter, hashCodeChanged);
        }
    }

    private void assertFieldShouldBeIgnored(boolean equalToItself, boolean equalsChanged, T object, FieldAccessor fieldAccessor, String fieldName) {
        boolean anotherFieldIsMarkedAsId;
        if (!this.shouldAllFieldsBeUsed(fieldAccessor) || !this.isFieldEligible(fieldAccessor)) {
            return;
        }
        boolean fieldShouldBeIgnored = this.ignoredFields.contains(fieldName);
        boolean thisFieldIsMarkedAsId = this.annotationCache.hasFieldAnnotation(this.type, fieldName, SupportedAnnotations.ID);
        boolean bl = anotherFieldIsMarkedAsId = !thisFieldIsMarkedAsId && this.annotationCache.hasClassAnnotation(this.type, SupportedAnnotations.ID);
        if (!this.fieldIsEmptyAndItsOk(thisFieldIsMarkedAsId, fieldAccessor, object)) {
            if (!fieldShouldBeIgnored) {
                Assert.assertTrue(Formatter.of("Significant fields: equals does not use %%.", fieldName), equalToItself);
            }
            this.assertFieldShouldHaveBeenUsed(fieldName, equalsChanged, fieldShouldBeIgnored, thisFieldIsMarkedAsId, anotherFieldIsMarkedAsId);
        }
        this.assertFieldShouldNotBeUsed(fieldName, equalsChanged, fieldShouldBeIgnored, thisFieldIsMarkedAsId, anotherFieldIsMarkedAsId);
    }

    private boolean shouldAllFieldsBeUsed(FieldAccessor fieldAccessor) {
        return !this.warningsToSuppress.contains((Object)Warning.ALL_FIELDS_SHOULD_BE_USED) && (!this.warningsToSuppress.contains((Object)Warning.ALL_NONFINAL_FIELDS_SHOULD_BE_USED) || fieldAccessor.fieldIsFinal());
    }

    private boolean isFieldEligible(FieldAccessor fieldAccessor) {
        return !fieldAccessor.fieldIsStatic() && !fieldAccessor.fieldIsTransient() && !fieldAccessor.fieldIsEmptyOrSingleValueEnum() && !this.annotationCache.hasFieldAnnotation(this.type, fieldAccessor.getField().getName(), SupportedAnnotations.TRANSIENT);
    }

    private boolean fieldIsEmptyAndItsOk(boolean thisFieldIsMarkedAsId, FieldAccessor fieldAccessor, T object) {
        Object value = fieldAccessor.get(object);
        Class<?> fieldType = fieldAccessor.getFieldType();
        Object zero = PrimitiveMappers.DEFAULT_WRAPPED_VALUE_MAPPER.get(fieldType);
        boolean fieldIsEmpty = value == null || value.equals(zero);
        return thisFieldIsMarkedAsId && this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY) && fieldIsEmpty;
    }

    private void assertFieldShouldHaveBeenUsed(String fieldName, boolean equalsChanged, boolean fieldShouldBeIgnored, boolean thisFieldIsMarkedAsId, boolean anotherFieldIsMarkedAsId) {
        String message = thisFieldIsMarkedAsId ? "Significant fields: %% is marked @Id or @EmbeddedId and Warning.SURROGATE_KEY is suppressed, but equals does not use it." : (anotherFieldIsMarkedAsId ? "Significant fields: equals does not use %%, or it is stateless.\nSuppress Warning.SURROGATE_KEY if you want to use only the @Id or @EmbeddedId field(s)." : "Significant fields: equals does not use %%, or it is stateless.");
        Assert.assertTrue(Formatter.of(message, fieldName), fieldShouldBeIgnored || equalsChanged);
    }

    private void assertFieldShouldNotBeUsed(String fieldName, boolean equalsChanged, boolean fieldShouldBeIgnored, boolean thisFieldIsMarkedAsId, boolean anotherFieldIsMarkedAsId) {
        String message = thisFieldIsMarkedAsId ? "Significant fields: %% is marked @Id or @EmbeddedId so equals should not use it, but it does.\nSuppress Warning.SURROGATE_KEY if you want to use only the @Id or @EmbeddedId field(s)." : (anotherFieldIsMarkedAsId ? "Significant fields: equals should not use %% because Warning.SURROGATE_KEY is suppressed and it is not marked as @Id or @EmbeddedId, but it does." : "Significant fields: equals should not use %%, but it does.");
        Assert.assertTrue(Formatter.of(message, fieldName), !fieldShouldBeIgnored || !equalsChanged || this.skipCertainTestsThatDontMatterWhenValuesAreNull);
    }
}

