/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class StringFieldCheck<T>
implements FieldCheck<T> {
    public static final String ERROR_DOC_TITLE = "String equality";
    private final PrefabValues prefabValues;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="PrefabValues is inherently mutable.")
    public StringFieldCheck(PrefabValues prefabValues, CachedHashCodeInitializer<T> cachedHashCodeInitializer) {
        this.prefabValues = prefabValues;
        this.cachedHashCodeInitializer = cachedHashCodeInitializer;
    }

    @Override
    @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="String prefab values are probably not localized.")
    public void execute(ObjectAccessor<T> referenceAccessor, ObjectAccessor<T> copyAccessor, FieldAccessor fieldAccessor) {
        if (String.class.equals(fieldAccessor.getFieldType()) && !fieldAccessor.fieldIsStatic()) {
            boolean theirHashCodesAreEqual;
            T copy;
            T reference;
            Field field = fieldAccessor.getField();
            String red = (String)this.prefabValues.giveRed(new TypeTag(String.class, new TypeTag[0]));
            try {
                reference = referenceAccessor.withFieldSetTo(field, red.toLowerCase()).get();
                copy = copyAccessor.withFieldSetTo(field, red.toUpperCase()).get();
            }
            catch (ReflectionException ignored) {
                return;
            }
            boolean theyAreEqual = reference.equals(copy);
            boolean bl = theirHashCodesAreEqual = this.cachedHashCodeInitializer.getInitializedHashCode(reference) == this.cachedHashCodeInitializer.getInitializedHashCode(copy);
            if (theyAreEqual && !theirHashCodesAreEqual) {
                Assert.fail(Formatter.of("String equality: class uses equalsIgnoreCase to compare String field %%, but hashCode is case-sensitive. Use toUpperCase() to determine the hashCode.", field.getName()));
            }
        }
    }
}

