/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.RecordsHelper;
import nl.jqno.equalsverifier.internal.reflection.SealedTypesHelper;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.NonnullAnnotationVerifier;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class ClassAccessor<T> {
    private final Class<T> type;
    private final PrefabValues prefabValues;

    ClassAccessor(Class<T> type, PrefabValues prefabValues) {
        this.type = type;
        this.prefabValues = prefabValues;
    }

    public static <T> ClassAccessor<T> of(Class<T> type, PrefabValues prefabValues) {
        return new ClassAccessor<T>(type, prefabValues);
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isRecord() {
        return RecordsHelper.isRecord(this.type);
    }

    public boolean isSealed() {
        return SealedTypesHelper.isSealed(this.type);
    }

    public boolean declaresField(Field field) {
        try {
            this.type.getDeclaredField(field.getName());
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public boolean declaresEquals() {
        return this.declaresMethod("equals", Object.class);
    }

    public boolean declaresHashCode() {
        return this.declaresMethod("hashCode", new Class[0]);
    }

    private boolean declaresMethod(String name, Class<?> ... parameterTypes) {
        try {
            this.type.getDeclaredMethod(name, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean hasMethod(String name, Class<?> ... parameterTypes) {
        try {
            this.type.getMethod(name, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isEqualsAbstract() {
        return this.isMethodAbstract("equals", Object.class);
    }

    public boolean isHashCodeAbstract() {
        return this.isMethodAbstract("hashCode", new Class[0]);
    }

    private boolean isMethodAbstract(String name, Class<?> ... parameterTypes) {
        return Rethrow.rethrow(() -> Modifier.isAbstract(this.type.getMethod(name, parameterTypes).getModifiers()));
    }

    public boolean isEqualsInheritedFromObject() {
        ClassAccessor<T> i = this;
        while (i.getType() != Object.class) {
            if (i.declaresEquals() && !i.isEqualsAbstract()) {
                return false;
            }
            i = i.getSuperAccessor();
        }
        return true;
    }

    public ClassAccessor<? super T> getSuperAccessor() {
        return ClassAccessor.of(this.type.getSuperclass(), this.prefabValues);
    }

    public T getRedObject(TypeTag enclosingType) {
        return this.getRedAccessor(enclosingType).get();
    }

    public ObjectAccessor<T> getRedAccessor(TypeTag enclosingType) {
        return this.buildObjectAccessor().scramble(this.prefabValues, enclosingType);
    }

    public T getBlueObject(TypeTag enclosingType) {
        return this.getBlueAccessor(enclosingType).get();
    }

    public ObjectAccessor<T> getBlueAccessor(TypeTag enclosingType) {
        return this.buildObjectAccessor().scramble(this.prefabValues, enclosingType).scramble(this.prefabValues, enclosingType);
    }

    public ObjectAccessor<T> getDefaultValuesAccessor(TypeTag enclosingType, boolean isWarningNullSuppressed, boolean isWarningZeroSuppressed, Set<String> nonnullFields, AnnotationCache annotationCache) {
        Predicate<Field> canBeDefault = f -> this.canBeDefault((Field)f, enclosingType, isWarningNullSuppressed, isWarningZeroSuppressed, nonnullFields, annotationCache);
        return this.buildObjectAccessor().clear(canBeDefault, this.prefabValues, enclosingType);
    }

    private boolean canBeDefault(Field f, TypeTag enclosingType, boolean isWarningNullSuppressed, boolean isWarningZeroSuppressed, Set<String> nonnullFields, AnnotationCache annotationCache) {
        FieldAccessor accessor = FieldAccessor.of(f);
        if (accessor.fieldIsPrimitive()) {
            return !isWarningZeroSuppressed;
        }
        boolean isAnnotated = NonnullAnnotationVerifier.fieldIsNonnull(f, annotationCache);
        boolean isMentionedExplicitly = nonnullFields.contains(f.getName());
        return !isWarningNullSuppressed && !isAnnotated && !isMentionedExplicitly;
    }

    private ObjectAccessor<T> buildObjectAccessor() {
        T object = Instantiator.of(this.type).instantiate();
        return ObjectAccessor.of(object);
    }
}

