/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldModifier;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;

final class InPlaceObjectAccessor<T>
extends ObjectAccessor<T> {
    InPlaceObjectAccessor(T object, Class<T> type) {
        super(object, type);
    }

    @Override
    public T copy() {
        Object copy = Instantiator.of(this.type()).instantiate();
        return this.copyInto(copy);
    }

    @Override
    public <S extends T> S copyIntoSubclass(Class<S> subclass) {
        S copy = Instantiator.of(subclass).instantiate();
        return this.copyInto(copy);
    }

    @Override
    public T copyIntoAnonymousSubclass() {
        Object copy = Instantiator.of(this.type()).instantiateAnonymousSubclass();
        return this.copyInto(copy);
    }

    private <S> S copyInto(S copy) {
        for (Field field : FieldIterable.of(this.type())) {
            this.fieldModifierFor(field).copyTo(copy);
        }
        return copy;
    }

    @Override
    public ObjectAccessor<T> scramble(PrefabValues prefabValues, TypeTag enclosingType) {
        for (Field field : FieldIterable.of(this.type())) {
            this.fieldModifierFor(field).changeField(prefabValues, enclosingType);
        }
        return this;
    }

    @Override
    public ObjectAccessor<T> shallowScramble(PrefabValues prefabValues, TypeTag enclosingType) {
        for (Field field : FieldIterable.ofIgnoringSuper(this.type())) {
            this.fieldModifierFor(field).changeField(prefabValues, enclosingType);
        }
        return this;
    }

    @Override
    public ObjectAccessor<T> clear(Predicate<Field> canBeDefault, PrefabValues prefabValues, TypeTag enclosingType) {
        for (Field field : FieldIterable.of(this.type())) {
            FieldModifier modifier = this.fieldModifierFor(field);
            modifier.defaultField();
            if (canBeDefault.test(field)) continue;
            modifier.changeField(prefabValues, enclosingType);
        }
        return this;
    }

    @Override
    public ObjectAccessor<T> withDefaultedField(Field field) {
        this.fieldModifierFor(field).defaultField();
        return this;
    }

    @Override
    public ObjectAccessor<T> withChangedField(Field field, PrefabValues prefabValues, TypeTag enclosingType) {
        this.fieldModifierFor(field).changeField(prefabValues, enclosingType);
        return this;
    }

    @Override
    public ObjectAccessor<T> withFieldSetTo(Field field, Object newValue) {
        this.fieldModifierFor(field).set(newValue);
        return this;
    }

    private FieldModifier fieldModifierFor(Field field) {
        return FieldModifier.of(field, this.get());
    }
}

