/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class HierarchyChecker<T>
implements Checker {
    private final Configuration<T> config;
    private final Class<T> type;
    private final TypeTag typeTag;
    private final ClassAccessor<T> classAccessor;
    private final Class<? extends T> redefinedSubclass;
    private final boolean strictnessSuppressed;
    private final boolean hasRedefinedSubclass;
    private final boolean typeIsFinal;
    private final boolean typeIsSealed;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public HierarchyChecker(Configuration<T> config) {
        this.config = config;
        this.strictnessSuppressed = config.getWarningsToSuppress().contains((Object)Warning.STRICT_INHERITANCE);
        boolean bl = this.hasRedefinedSubclass = config.getRedefinedSubclass() != null;
        if (this.strictnessSuppressed && this.hasRedefinedSubclass) {
            Assert.fail(Formatter.of("withRedefinedSubclass and weakInheritanceCheck are mutually exclusive.", new Object[0]));
        }
        this.type = config.getType();
        this.typeTag = config.getTypeTag();
        this.classAccessor = config.getClassAccessor();
        this.redefinedSubclass = config.getRedefinedSubclass();
        this.typeIsFinal = Modifier.isFinal(this.type.getModifiers());
        this.typeIsSealed = this.classAccessor.isSealed();
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
    }

    @Override
    public void check() {
        this.checkSuperclass();
        this.checkSubclass();
        this.checkRedefinedSubclass();
        this.checkFinalEqualsMethod();
    }

    private void checkSuperclass() {
        ClassAccessor<T> superAccessor = this.classAccessor.getSuperAccessor();
        if (superAccessor.isEqualsInheritedFromObject() || superAccessor.isSealed()) {
            return;
        }
        if (this.config.hasRedefinedSuperclass() || this.config.isUsingGetClass()) {
            T reference = this.classAccessor.getRedObject(this.typeTag);
            Object equalSuper = this.getEqualSuper(reference);
            Formatter formatter = Formatter.of("Redefined superclass:\n  %%\nshould not equal superclass instance\n  %%\nbut it does.", reference, equalSuper);
            try {
                Assert.assertFalse(formatter, reference.equals(equalSuper) || equalSuper.equals(reference));
            }
            catch (AbstractMethodError abstractMethodError) {}
        } else {
            this.safelyCheckSuperProperties(this.classAccessor.getRedAccessor(this.typeTag));
            this.safelyCheckSuperProperties(this.classAccessor.getDefaultValuesAccessor(this.typeTag, this.config.getWarningsToSuppress().contains((Object)Warning.NULL_FIELDS), this.config.getWarningsToSuppress().contains((Object)Warning.ZERO_FIELDS), this.config.getNonnullFields(), this.config.getAnnotationCache()));
        }
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="The equals method in a superclasses can throw an NPE, but it's a specific non-goal to do something with that here.")
    private void safelyCheckSuperProperties(ObjectAccessor<T> referenceAccessor) {
        if (this.strictnessSuppressed) {
            return;
        }
        T reference = referenceAccessor.get();
        Object equalSuper = this.getEqualSuper(reference);
        T shallowCopy = referenceAccessor.copy();
        ObjectAccessor<T> scrambledAccessor = ObjectAccessor.of(shallowCopy).shallowScramble(this.config.getPrefabValues(), this.typeTag);
        try {
            this.checkSuperProperties(reference, equalSuper, scrambledAccessor.get());
        }
        catch (AbstractMethodError | NullPointerException throwable) {
            // empty catch block
        }
    }

    private void checkSuperProperties(T reference, Object equalSuper, T shallow) {
        Formatter symmetryFormatter = Formatter.of("Symmetry:\n  %%\ndoes not equal superclass instance\n  %%", reference, equalSuper);
        Assert.assertTrue(symmetryFormatter, reference.equals(equalSuper) && equalSuper.equals(reference));
        Formatter transitivityFormatter = Formatter.of("Transitivity:\n  %%\nand\n  %%\nboth equal superclass instance\n  %%\nwhich implies they equal each other.", reference, shallow, equalSuper);
        Assert.assertTrue(transitivityFormatter, reference.equals(shallow) || reference.equals(equalSuper) != equalSuper.equals(shallow));
        int referenceHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(reference);
        int equalSuperHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(equalSuper);
        Formatter superclassFormatter = Formatter.of("Superclass: hashCode for\n  %% (%%)\nshould be equal to hashCode for superclass instance\n  %% (%%)", reference, referenceHashCode, equalSuper, equalSuperHashCode);
        Assert.assertTrue(superclassFormatter, referenceHashCode == equalSuperHashCode);
    }

    private Object getEqualSuper(T reference) {
        return ObjectAccessor.of(reference, this.type.getSuperclass()).copy();
    }

    private void checkSubclass() {
        if (this.typeIsFinal || this.typeIsSealed || this.strictnessSuppressed) {
            return;
        }
        ObjectAccessor<T> referenceAccessor = this.classAccessor.getRedAccessor(this.typeTag);
        T reference = referenceAccessor.get();
        T equalSub = referenceAccessor.copyIntoAnonymousSubclass();
        if (this.config.isUsingGetClass()) {
            Formatter formatter = Formatter.of("Subclass: object is equal to an instance of a trivial subclass with equal fields:\n  %%\nThis should not happen when using getClass().", reference);
            Assert.assertFalse(formatter, reference.equals(equalSub));
        } else {
            Formatter formatter = Formatter.of("Subclass: object is not equal to an instance of a trivial subclass with equal fields:\n  %%\nMaybe you forgot to add usingGetClass(). Otherwise, consider making the class final or use EqualsVerifier.simple().", reference);
            Assert.assertTrue(formatter, reference.equals(equalSub));
        }
    }

    private void checkRedefinedSubclass() {
        if (this.typeIsFinal || this.typeIsSealed || !this.hasRedefinedSubclass) {
            return;
        }
        if (this.methodIsFinal("equals", Object.class)) {
            Assert.fail(Formatter.of("Subclass: %% has a final equals method.\nNo need to supply a redefined subclass.", this.type.getSimpleName()));
        }
        ObjectAccessor<T> referenceAccessor = this.classAccessor.getRedAccessor(this.typeTag);
        T reference = referenceAccessor.get();
        T redefinedSub = referenceAccessor.copyIntoSubclass(this.redefinedSubclass);
        Assert.assertFalse(Formatter.of("Subclass:\n  %%\nequals subclass instance\n  %%", reference, redefinedSub), reference.equals(redefinedSub));
    }

    private void checkFinalEqualsMethod() {
        boolean isEntity = this.config.getAnnotationCache().hasClassAnnotation(this.type, SupportedAnnotations.ENTITY);
        if (this.strictnessSuppressed || isEntity || this.typeIsFinal || this.hasRedefinedSubclass) {
            return;
        }
        boolean equalsIsFinal = this.methodIsFinal("equals", Object.class);
        boolean hashCodeIsFinal = this.methodIsFinal("hashCode", new Class[0]);
        if (this.config.isUsingGetClass()) {
            Assert.assertEquals(Formatter.of("Finality: equals and hashCode must both be final or both be non-final.", new Object[0]), equalsIsFinal, hashCodeIsFinal);
        } else {
            Formatter equalsFormatter = Formatter.of("Subclass: equals is not final.\nMake your class or your equals method final, or supply an instance of a redefined subclass using withRedefinedSubclass if equals cannot be final.", new Object[0]);
            Assert.assertTrue(equalsFormatter, equalsIsFinal);
            Formatter hashCodeFormatter = Formatter.of("Subclass: hashCode is not final.\nMake your class or your hashCode method final, or supply an instance of a redefined subclass using withRedefinedSubclass if hashCode cannot be final.", new Object[0]);
            Assert.assertTrue(hashCodeFormatter, hashCodeIsFinal);
        }
    }

    private boolean methodIsFinal(String methodName, Class<?> ... parameterTypes) {
        return Rethrow.rethrow(() -> {
            Method method = this.type.getMethod(methodName, parameterTypes);
            return Modifier.isFinal(method.getModifiers());
        });
    }
}

