/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public final class FieldAccessor {
    private final Field field;

    private FieldAccessor(Field field) {
        this.field = field;
    }

    public static FieldAccessor of(Field field) {
        return new FieldAccessor(field);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Can't defensively copy a Field.")
    public Field getField() {
        return this.field;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public boolean fieldIsPrimitive() {
        return this.getFieldType().isPrimitive();
    }

    public boolean fieldIsFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean fieldIsStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public boolean fieldIsTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    public boolean fieldIsEmptyOrSingleValueEnum() {
        Class<?> type = this.field.getType();
        return type.isEnum() && type.getEnumConstants().length <= 1;
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Only called in test code, not production.")
    public Object get(Object object) {
        this.field.setAccessible(true);
        return Rethrow.rethrow(() -> this.field.get(object));
    }

    public boolean canBeModifiedReflectively() {
        if (this.field.isSynthetic()) {
            return false;
        }
        int modifiers = this.field.getModifiers();
        return !Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers);
    }
}

