/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues.factories;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;

public class FallbackFactory<T>
implements PrefabValueFactory<T> {
    @Override
    public Tuple<T> createValues(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
        LinkedHashSet clone = (LinkedHashSet)typeStack.clone();
        clone.add(tag);
        Class type = tag.getType();
        if (type.isEnum()) {
            return this.giveEnumInstances(tag);
        }
        if (type.isArray()) {
            return this.giveArrayInstances(tag, prefabValues, clone);
        }
        this.traverseFields(tag, prefabValues, clone);
        return this.giveInstances(tag, prefabValues, clone);
    }

    private Tuple<T> giveEnumInstances(TypeTag tag) {
        Class type = tag.getType();
        T[] enumConstants = type.getEnumConstants();
        switch (enumConstants.length) {
            case 0: {
                return new Tuple<Object>(null, null, null);
            }
            case 1: {
                return new Tuple(enumConstants[0], enumConstants[0], enumConstants[0]);
            }
        }
        return new Tuple(enumConstants[0], enumConstants[1], enumConstants[0]);
    }

    private Tuple<T> giveArrayInstances(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
        Class type = tag.getType();
        Class<?> componentType = type.getComponentType();
        TypeTag componentTag = new TypeTag(componentType, new TypeTag[0]);
        prefabValues.realizeCacheFor(componentTag, typeStack);
        Object red = Array.newInstance(componentType, 1);
        Array.set(red, 0, prefabValues.giveRed(componentTag));
        Object blue = Array.newInstance(componentType, 1);
        Array.set(blue, 0, prefabValues.giveBlue(componentTag));
        Object redCopy = Array.newInstance(componentType, 1);
        Array.set(redCopy, 0, prefabValues.giveRed(componentTag));
        return new Tuple<Object>(red, blue, redCopy);
    }

    private void traverseFields(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
        Class type = tag.getType();
        for (Field field : FieldIterable.of(type)) {
            int modifiers = field.getModifiers();
            boolean isStaticAndFinal = Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
            if (isStaticAndFinal) continue;
            prefabValues.realizeCacheFor(TypeTag.of(field, tag), typeStack);
        }
    }

    private Tuple<T> giveInstances(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
        ClassAccessor accessor = ClassAccessor.of(tag.getType(), prefabValues);
        Object red = accessor.getRedObject(tag, typeStack);
        Object blue = accessor.getBlueObject(tag, typeStack);
        Object redCopy = accessor.getRedObject(tag, typeStack);
        return new Tuple(red, blue, redCopy);
    }
}

