/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.internal.exceptions.ModuleException;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldModifier;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;

final class InPlaceObjectAccessor<T>
extends ObjectAccessor<T> {
    InPlaceObjectAccessor(T object, Class<T> type) {
        super(object, type);
    }

    @Override
    public T copy() {
        Object copy = Instantiator.of(this.type()).instantiate();
        return this.copyInto(copy);
    }

    @Override
    public <S extends T> S copyIntoSubclass(Class<S> subclass) {
        S copy = Instantiator.of(subclass).instantiate();
        return this.copyInto(copy);
    }

    @Override
    public T copyIntoAnonymousSubclass() {
        Object copy = Instantiator.of(this.type()).instantiateAnonymousSubclass();
        return this.copyInto(copy);
    }

    private <S> S copyInto(S copy) {
        for (Field field : FieldIterable.of(this.type())) {
            this.fieldModifierFor(field).copyTo(copy);
        }
        return copy;
    }

    @Override
    public ObjectAccessor<T> scramble(PrefabValues prefabValues, TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack) {
        return this.scrambleInternal(prefabValues, enclosingType, typeStack, FieldIterable::of);
    }

    @Override
    public ObjectAccessor<T> shallowScramble(PrefabValues prefabValues, TypeTag enclosingType) {
        return this.scrambleInternal(prefabValues, enclosingType, new LinkedHashSet<TypeTag>(), FieldIterable::ofIgnoringSuper);
    }

    private ObjectAccessor<T> scrambleInternal(PrefabValues prefabValues, TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack, Function<Class<?>, FieldIterable> it) {
        for (Field field : it.apply(this.type())) {
            try {
                this.fieldModifierFor(field).changeField(prefabValues, enclosingType, typeStack);
            }
            catch (ModuleException e) {
                this.handleInaccessibleObjectException(e.getCause(), field);
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().endsWith("InaccessibleObjectException")) {
                    this.handleInaccessibleObjectException(e, field);
                    continue;
                }
                throw e;
            }
        }
        return this;
    }

    private void handleInaccessibleObjectException(Throwable e, Field field) {
        if (e.getMessage() != null && e.getMessage().contains(this.type().getCanonicalName())) {
            throw new ModuleException("The class is not accessible via the Java Module system. Consider opening the module that contains it.", e);
        }
        throw new ModuleException("Field " + field.getName() + " of type " + field.getType().getName() + " is not accessible via the Java Module System.\nConsider opening the module that contains it, or add prefab values for type " + field.getType().getName() + ".", e);
    }

    @Override
    public ObjectAccessor<T> clear(Predicate<Field> canBeDefault, PrefabValues prefabValues, TypeTag enclosingType) {
        for (Field field : FieldIterable.of(this.type())) {
            FieldModifier modifier = this.fieldModifierFor(field);
            modifier.defaultField();
            if (canBeDefault.test(field)) continue;
            modifier.changeField(prefabValues, enclosingType);
        }
        return this;
    }

    @Override
    public ObjectAccessor<T> withDefaultedField(Field field) {
        this.fieldModifierFor(field).defaultField();
        return this;
    }

    @Override
    public ObjectAccessor<T> withChangedField(Field field, PrefabValues prefabValues, TypeTag enclosingType) {
        this.fieldModifierFor(field).changeField(prefabValues, enclosingType);
        return this;
    }

    @Override
    public ObjectAccessor<T> withFieldSetTo(Field field, Object newValue) {
        this.fieldModifierFor(field).set(newValue);
        return this;
    }

    private FieldModifier fieldModifierFor(Field field) {
        return FieldModifier.of(field, this.get());
    }
}

