/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class ListBuilders {
    private ListBuilders() {
    }

    @SafeVarargs
    public static <T> List<T> buildListOfAtLeastOne(T first, T ... more) {
        if (first == null) {
            throw new IllegalArgumentException("First example is null.");
        }
        ArrayList<T> result = new ArrayList<T>();
        result.add(first);
        ListBuilders.addArrayElementsToList(result, more);
        return result;
    }

    @SafeVarargs
    public static <T> List<T> buildListOfAtLeastTwo(T first, T second, T ... more) {
        if (first == null) {
            throw new IllegalArgumentException("First example is null.");
        }
        if (second == null) {
            throw new IllegalArgumentException("Second example is null.");
        }
        ArrayList<T> result = new ArrayList<T>();
        result.add(first);
        result.add(second);
        ListBuilders.addArrayElementsToList(result, more);
        return result;
    }

    @SafeVarargs
    private static <T> void addArrayElementsToList(List<T> list, T ... more) {
        if (more != null) {
            for (T e : more) {
                if (e == null) {
                    throw new IllegalArgumentException("One of the examples is null.");
                }
                list.add(e);
            }
        }
    }

    public static <T> List<T> fromIterable(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(t);
        }
        return result;
    }

    public static <T> boolean listContainsDuplicates(List<T> list) {
        return list.size() != new HashSet<T>(list).size();
    }
}

