/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public final class FieldModifier {
    private final Field field;
    private final Object object;

    private FieldModifier(Field field, Object object) {
        this.field = field;
        this.object = object;
    }

    public static FieldModifier of(Field field, Object object) {
        return new FieldModifier(field, object);
    }

    public void set(Object value) {
        this.change(() -> this.field.set(this.object, value), true);
    }

    public void defaultField() {
        this.change(this::setFieldToDefault, false);
    }

    public void defaultStaticField() {
        this.change(this::setFieldToDefault, true);
    }

    private void setFieldToDefault() throws IllegalAccessException {
        Class<?> type = this.field.getType();
        this.field.set(this.object, PrimitiveMappers.DEFAULT_VALUE_MAPPER.get(type));
    }

    public void copyTo(Object to) {
        this.change(() -> this.field.set(to, this.field.get(this.object)), false);
    }

    public void changeField(PrefabValues prefabValues, TypeTag enclosingType) {
        this.changeField(prefabValues, enclosingType, new LinkedHashSet<TypeTag>());
    }

    public void changeField(PrefabValues prefabValues, TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack) {
        FieldChanger fm = () -> {
            TypeTag tag = TypeTag.of(this.field, enclosingType);
            Object newValue = prefabValues.giveOther(tag, this.field.get(this.object), typeStack);
            this.field.set(this.object, newValue);
        };
        this.change(fm, false);
    }

    private void change(FieldChanger changer, boolean includeStatic) {
        FieldAccessor accessor = FieldAccessor.of(this.field);
        if (!accessor.canBeModifiedReflectively()) {
            return;
        }
        if (!includeStatic && accessor.fieldIsStatic()) {
            return;
        }
        this.field.setAccessible(true);
        Rethrow.rethrow(() -> this.wrappedChange(changer));
    }

    private void wrappedChange(FieldChanger changer) throws IllegalAccessException {
        try {
            changer.change();
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("Can not set")) {
                throw new ReflectionException("Reflection error: perhaps a ClassLoader problem?\nTry re-running with #withResetCaches()", e);
            }
            throw e;
        }
    }

    @FunctionalInterface
    private static interface FieldChanger {
        public void change() throws IllegalAccessException;
    }
}

