/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.exceptions.RecursionException;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.prefabvalues.Cache;
import nl.jqno.equalsverifier.internal.prefabvalues.FactoryCache;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.FallbackFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;

public class PrefabValues {
    private final Cache cache = new Cache();
    private final FactoryCache factoryCache;
    private final PrefabValueFactory<?> fallbackFactory = new FallbackFactory();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="A cache is inherently mutable.")
    public PrefabValues(FactoryCache factoryCache) {
        this.factoryCache = factoryCache;
    }

    public <T> T giveRed(TypeTag tag) {
        return this.giveTuple(tag).getRed();
    }

    public <T> T giveBlue(TypeTag tag) {
        return this.giveTuple(tag).getBlue();
    }

    public <T> T giveRedCopy(TypeTag tag) {
        return this.giveTuple(tag).getRedCopy();
    }

    public <T> Tuple<T> giveTuple(TypeTag tag) {
        return this.giveTuple(tag, new LinkedHashSet<TypeTag>());
    }

    public <T> Tuple<T> giveTuple(TypeTag tag, LinkedHashSet<TypeTag> typeStack) {
        this.realizeCacheFor(tag, typeStack);
        return this.cache.getTuple(tag);
    }

    public <T> T giveOther(TypeTag tag, T value) {
        return this.giveOther(tag, value, new LinkedHashSet<TypeTag>());
    }

    public <T> T giveOther(TypeTag tag, T value, LinkedHashSet<TypeTag> typeStack) {
        Class type = tag.getType();
        if (value != null && !type.isAssignableFrom(value.getClass()) && !this.wraps(type, value.getClass())) {
            throw new ReflectionException("TypeTag does not match value.");
        }
        Tuple<T> tuple = this.giveTuple(tag, typeStack);
        if (tuple.getRed() == null) {
            return null;
        }
        if (type.isArray() && this.arraysAreDeeplyEqual(tuple.getRed(), value)) {
            return tuple.getBlue();
        }
        if (!type.isArray() && value != null) {
            try {
                if (tuple.getRed().equals(value)) {
                    return tuple.getBlue();
                }
            }
            catch (AbstractMethodError e) {
                return tuple.getRed();
            }
        }
        return tuple.getRed();
    }

    private boolean wraps(Class<?> expectedClass, Class<?> actualClass) {
        return PrimitiveMappers.PRIMITIVE_OBJECT_MAPPER.get(expectedClass) == actualClass;
    }

    private boolean arraysAreDeeplyEqual(Object x, Object y) {
        return Arrays.deepEquals(new Object[]{x}, new Object[]{y});
    }

    public <T> void realizeCacheFor(TypeTag tag, LinkedHashSet<TypeTag> typeStack) {
        if (!this.cache.contains(tag)) {
            Tuple<T> tuple = this.createTuple(tag, typeStack);
            this.addToCache(tag, tuple);
        }
    }

    private <T> Tuple<T> createTuple(TypeTag tag, LinkedHashSet<TypeTag> typeStack) {
        if (typeStack.contains(tag)) {
            throw new RecursionException(typeStack);
        }
        Class type = tag.getType();
        if (this.factoryCache.contains(type)) {
            PrefabValueFactory factory = this.factoryCache.get(type);
            return factory.createValues(tag, this, typeStack);
        }
        Tuple<?> result = this.fallbackFactory.createValues(tag, this, typeStack);
        return result;
    }

    private void addToCache(TypeTag tag, Tuple<?> tuple) {
        this.cache.put(tag, tuple.getRed(), tuple.getBlue(), tuple.getRedCopy());
    }
}

