/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.vintage;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.instantiation.VintageValueProvider;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public final class FieldModifier {
    private final Field field;
    private final Object object;

    private FieldModifier(Field field, Object object) {
        this.field = field;
        this.object = object;
    }

    public static FieldModifier of(Field field, Object object) {
        return new FieldModifier(field, object);
    }

    public void copyTo(Object to) {
        this.change(() -> this.field.set(to, this.field.get(this.object)), false);
    }

    public void changeField(VintageValueProvider valueProvider, TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack) {
        FieldChanger fm = () -> {
            TypeTag tag = TypeTag.of(this.field, enclosingType);
            Object newValue = valueProvider.giveOther(tag, this.field.get(this.object), typeStack);
            this.field.set(this.object, newValue);
        };
        this.change(fm, false);
    }

    private void change(FieldChanger changer, boolean includeStatic) {
        FieldProbe probe = FieldProbe.of(this.field);
        if (!probe.canBeModifiedReflectively()) {
            return;
        }
        if (!includeStatic && probe.isStatic()) {
            return;
        }
        this.field.setAccessible(true);
        Rethrow.rethrow(() -> this.wrappedChange(changer));
    }

    private void wrappedChange(FieldChanger changer) throws IllegalAccessException {
        try {
            changer.change();
        }
        catch (IllegalArgumentException e) {
            String msg = e.getMessage();
            if (msg.startsWith("Can not set") || msg.startsWith("Can not get")) {
                throw new ReflectionException("Reflection error: try adding a prefab value for field " + this.field.getName() + " of type " + this.field.getType().getName(), e);
            }
            throw e;
        }
    }

    @FunctionalInterface
    private static interface FieldChanger {
        public void change() throws IllegalAccessException;
    }
}

