/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class RecordChecker<T>
implements Checker {
    private final Context<T> context;
    private final SubjectCreator<T> subjectCreator;

    public RecordChecker(Context<T> context) {
        this.context = context;
        this.subjectCreator = context.getSubjectCreator();
    }

    @Override
    public void check() {
        ClassProbe<T> probe = this.context.getClassProbe();
        if (!probe.isRecord()) {
            return;
        }
        this.verifyRecordPrecondition(this.subjectCreator.plain());
        this.verifyRecordPrecondition(this.subjectCreator.withAllFieldsDefaulted());
    }

    private void verifyRecordPrecondition(T original) {
        Class<T> type = this.context.getType();
        T copy = this.subjectCreator.copy(original);
        if (original.equals(copy)) {
            return;
        }
        ArrayList<String> failedFields = new ArrayList<String>();
        for (Field f : FieldIterable.of(type)) {
            Method accessorMethod = this.getAccessorMethodFor(type, f);
            try {
                Object copyField;
                Object originalField = accessorMethod.invoke(original, new Object[0]);
                if (originalField.equals(copyField = accessorMethod.invoke(copy, new Object[0]))) continue;
                failedFields.add(f.getName());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Assert.fail(Formatter.of("Record: failed to run accessor method: " + accessorMethod, new Object[0]));
            }
        }
        Assert.fail(Formatter.of("Record invariant: constructor invariant failed for field%%: %%", failedFields.size() > 1 ? "s" : "", failedFields.stream().collect(Collectors.joining(","))));
    }

    private Method getAccessorMethodFor(Class<T> type, Field f) {
        return Rethrow.rethrow(() -> {
            Method result = type.getDeclaredMethod(f.getName(), new Class[0]);
            result.setAccessible(true);
            return result;
        });
    }
}

