/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class FloatAndDoubleFieldCheck<T>
implements FieldCheck<T> {
    private final SubjectCreator<T> subjectCreator;

    public FloatAndDoubleFieldCheck(SubjectCreator<T> subjectCreator) {
        this.subjectCreator = subjectCreator;
    }

    @Override
    public void execute(FieldProbe fieldProbe) {
        T copy;
        T reference;
        Class<?> type = fieldProbe.getType();
        if (this.isFloat(type)) {
            reference = this.subjectCreator.withFieldSetTo(fieldProbe.getField(), Float.valueOf(Float.NaN));
            copy = this.subjectCreator.withFieldSetTo(fieldProbe.getField(), Float.valueOf(Float.NaN));
            Assert.assertEquals(Formatter.of("Float: equals doesn't use Float.compare for field %%.", fieldProbe.getName()), reference, copy);
        }
        if (this.isDouble(type)) {
            reference = this.subjectCreator.withFieldSetTo(fieldProbe.getField(), Double.NaN);
            copy = this.subjectCreator.withFieldSetTo(fieldProbe.getField(), Double.NaN);
            Assert.assertEquals(Formatter.of("Double: equals doesn't use Double.compare for field %%.", fieldProbe.getName()), reference, copy);
        }
    }

    private boolean isFloat(Class<?> type) {
        return type == Float.TYPE || type == Float.class;
    }

    private boolean isDouble(Class<?> type) {
        return type == Double.TYPE || type == Double.class;
    }
}

