/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.instantiation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.instantiation.PrefabValueProvider;
import nl.jqno.equalsverifier.internal.reflection.instantiation.ValueProvider;

public class ChainedValueProvider
implements ValueProvider {
    private boolean locked = false;
    private final PrefabValueProvider prefabValueProvider;
    private final List<ValueProvider> providers = new ArrayList<ValueProvider>();

    public ChainedValueProvider(PrefabValueProvider prefabValueProvider) {
        this.prefabValueProvider = prefabValueProvider;
        this.providers.add(prefabValueProvider);
    }

    public void register(ValueProvider ... valueProviders) {
        if (this.locked) {
            throw new EqualsVerifierInternalBugException("Provider is locked; can't add any new ones.");
        }
        for (ValueProvider p : valueProviders) {
            this.providers.add(p);
        }
        this.locked = true;
    }

    @Override
    public <T> Optional<Tuple<T>> provide(TypeTag tag, String label) {
        return this.providers.stream().map(vp -> vp.provide(tag, label)).filter(Optional::isPresent).findFirst().orElse(Optional.empty()).map(tuple -> {
            this.prefabValueProvider.register(tag.getType(), label, tuple);
            return tuple;
        });
    }
}

