/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.instantiation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.instantiation.Key;
import nl.jqno.equalsverifier.internal.reflection.instantiation.ValueProvider;

public class GenericPrefabValueProvider
implements ValueProvider {
    private final Map<Key, Func<?>> cache;
    private final ValueProvider provider;

    public GenericPrefabValueProvider(GenericFactories factories, ValueProvider provider) {
        this.cache = factories.cache;
        this.provider = provider;
    }

    @Override
    public <T> Optional<Tuple<T>> provide(TypeTag tag, String label) {
        Class type = tag.getType();
        Optional<Func<T>> maybeFactory = this.findFactory(type, label);
        if (!maybeFactory.isPresent()) {
            return Optional.empty();
        }
        return this.findValue(tag, maybeFactory.get());
    }

    private <T> Optional<Func<T>> findFactory(Class<?> type, String label) {
        Func<?> result = this.cache.get(new Key(type, label));
        if (result == null) {
            result = this.cache.get(new Key(type, null));
        }
        return Optional.ofNullable(result);
    }

    private <T> Optional<Tuple<T>> findValue(TypeTag tag, Func<T> factory) {
        if (this.provider == null) {
            throw new EqualsVerifierInternalBugException("valueProvider not initialized in GenericPrefabValueProvider");
        }
        ArrayList redValues = new ArrayList();
        ArrayList blueValues = new ArrayList();
        ArrayList redCopyValues = new ArrayList();
        for (TypeTag generic : tag.getGenericTypes()) {
            Tuple tuple = this.provider.provide(generic);
            redValues.add(tuple.getRed());
            blueValues.add(tuple.getBlue());
            redCopyValues.add(tuple.getRedCopy());
        }
        T red = factory.apply(redValues);
        T blue = factory.apply(blueValues);
        T redCopy = factory.apply(redCopyValues);
        return Optional.of(Tuple.of(red, blue, redCopy));
    }

    public static class GenericFactories {
        private final Map<Key, Func<?>> cache = new HashMap();

        public <T> void register(Class<T> type, Func.Func1<?, T> factory) {
            Key key = new Key(type, null);
            this.cache.put(key, factory);
        }

        public <T> void register(Class<T> type, Func.Func2<?, ?, T> factory) {
            Key key = new Key(type, null);
            this.cache.put(key, factory);
        }

        public GenericFactories copy() {
            GenericFactories copy = new GenericFactories();
            copy.cache.putAll(this.cache);
            return copy;
        }
    }
}

