/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.instantiation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.instantiation.Key;
import nl.jqno.equalsverifier.internal.reflection.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;

public class PrefabValueProvider
implements ValueProvider {
    private final Map<Key, Tuple<?>> cache = new HashMap();

    public PrefabValueProvider() {
    }

    private PrefabValueProvider(PrefabValueProvider other) {
        this();
        this.cache.putAll(other.cache);
    }

    public PrefabValueProvider copy() {
        return new PrefabValueProvider(this);
    }

    @Override
    public <T> Optional<Tuple<T>> provide(TypeTag tag, String label) {
        Class type = tag.getType();
        Tuple<T> result = this.attempt(type, label);
        Class<?> boxed = PrimitiveMappers.PRIMITIVE_OBJECT_MAPPER.get(tag.getType());
        if (result == null && boxed != null) {
            result = this.attempt(boxed, label);
        }
        if (result == null) {
            result = this.attempt(type, null);
        }
        if (result == null && boxed != null) {
            result = this.attempt(boxed, null);
        }
        return Optional.ofNullable(result);
    }

    private <T> Tuple<T> attempt(Class<?> type, String label) {
        return this.cache.get(new Key(type, label));
    }

    public <T> void register(Class<T> type, String label, T red, T blue, T redCopy) {
        Tuple tuple = Tuple.of(red, blue, redCopy);
        this.register(type, label, tuple);
    }

    public <T> void register(Class<T> type, String label, Tuple<T> tuple) {
        Key key = new Key(type, label);
        this.cache.put(key, tuple);
    }

    public Set<String> getFieldNames() {
        return this.cache.keySet().stream().map(k -> k.label).collect(Collectors.toSet());
    }
}

