/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.vintage.prefabvalues.factories;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.instantiation.VintageValueProvider;
import nl.jqno.equalsverifier.internal.reflection.vintage.prefabvalues.factories.PrefabValueFactory;

public abstract class AbstractGenericFactory<T>
implements PrefabValueFactory<T> {
    public static final TypeTag OBJECT_TYPE_TAG = new TypeTag(Object.class, new TypeTag[0]);

    protected LinkedHashSet<TypeTag> cloneWith(LinkedHashSet<TypeTag> typeStack, TypeTag tag) {
        LinkedHashSet clone = (LinkedHashSet)typeStack.clone();
        clone.add(tag);
        return clone;
    }

    protected TypeTag copyGenericTypesInto(Class<?> type, TypeTag source) {
        ArrayList<TypeTag> genericTypes = new ArrayList<TypeTag>();
        for (TypeTag tag : source.getGenericTypes()) {
            genericTypes.add(tag);
        }
        return new TypeTag(type, genericTypes.toArray(new TypeTag[genericTypes.size()]));
    }

    protected TypeTag determineAndCacheActualTypeTag(int n, TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
        return this.determineAndCacheActualTypeTag(n, tag, valueProvider, typeStack, null);
    }

    protected TypeTag determineAndCacheActualTypeTag(int n, TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack, Class<?> bottomType) {
        TypeTag result = this.determineActualTypeTagFor(n, tag);
        if (bottomType != null && result.getType().equals(Object.class)) {
            result = new TypeTag(bottomType, new TypeTag[0]);
        }
        valueProvider.realizeCacheFor(result, typeStack);
        return result;
    }

    protected TypeTag determineActualTypeTagFor(int n, TypeTag typeTag) {
        List<TypeTag> genericTypes = typeTag.getGenericTypes();
        if (genericTypes.size() <= n) {
            return OBJECT_TYPE_TAG;
        }
        return genericTypes.get(n);
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="EV is run only from within unit tests")
    protected void invoke(Class<?> type, Object receiver, String methodName, Class<?>[] classes, Object[] values) {
        try {
            Method method = type.getMethod(methodName, classes);
            method.setAccessible(true);
            method.invoke(receiver, values);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }
}

