/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.vintage.prefabvalues.factories;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.instantiation.VintageValueProvider;
import nl.jqno.equalsverifier.internal.reflection.vintage.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.vintage.prefabvalues.factories.PrefabValueFactory;

public class FallbackFactory<T>
implements PrefabValueFactory<T> {
    private final Objenesis objenesis;

    public FallbackFactory(Objenesis objenesis) {
        this.objenesis = objenesis;
    }

    @Override
    public Tuple<T> createValues(TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
        LinkedHashSet clone = (LinkedHashSet)typeStack.clone();
        clone.add(tag);
        Class type = tag.getType();
        if (type.isEnum()) {
            return this.giveEnumInstances(tag);
        }
        if (type.isArray()) {
            return this.giveArrayInstances(tag, valueProvider, clone);
        }
        this.traverseFields(tag, valueProvider, clone);
        return this.giveInstances(tag, valueProvider, clone);
    }

    private Tuple<T> giveEnumInstances(TypeTag tag) {
        Class type = tag.getType();
        T[] enumConstants = type.getEnumConstants();
        switch (enumConstants.length) {
            case 0: {
                return new Tuple<Object>(null, null, null);
            }
            case 1: {
                return new Tuple(enumConstants[0], enumConstants[0], enumConstants[0]);
            }
        }
        return new Tuple(enumConstants[0], enumConstants[1], enumConstants[0]);
    }

    private Tuple<T> giveArrayInstances(TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
        Class type = tag.getType();
        Class<?> componentType = type.getComponentType();
        TypeTag componentTag = new TypeTag(componentType, new TypeTag[0]);
        valueProvider.realizeCacheFor(componentTag, typeStack);
        Object red = Array.newInstance(componentType, 1);
        Array.set(red, 0, valueProvider.giveRed(componentTag));
        Object blue = Array.newInstance(componentType, 1);
        Array.set(blue, 0, valueProvider.giveBlue(componentTag));
        Object redCopy = Array.newInstance(componentType, 1);
        Array.set(redCopy, 0, valueProvider.giveRed(componentTag));
        return new Tuple<Object>(red, blue, redCopy);
    }

    private void traverseFields(TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
        Class type = tag.getType();
        for (Field field : FieldIterable.of(type)) {
            FieldProbe probe = FieldProbe.of(field);
            boolean isStaticAndFinal = probe.isStatic() && probe.isFinal();
            if (isStaticAndFinal) continue;
            valueProvider.realizeCacheFor(TypeTag.of(field, tag), typeStack);
        }
    }

    private Tuple<T> giveInstances(TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
        ClassAccessor accessor = ClassAccessor.of(tag.getType(), valueProvider, this.objenesis);
        Object red = accessor.getRedObject(tag, typeStack);
        Object blue = accessor.getBlueObject(tag, typeStack);
        Object redCopy = accessor.getRedObject(tag, typeStack);
        return new Tuple(red, blue, redCopy);
    }
}

