/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.JavaApiPrefabValues;
import nl.jqno.equalsverifier.internal.reflection.instantiation.ChainedValueProvider;
import nl.jqno.equalsverifier.internal.reflection.instantiation.GenericPrefabValueProvider;
import nl.jqno.equalsverifier.internal.reflection.instantiation.PrefabValueProvider;
import nl.jqno.equalsverifier.internal.reflection.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.reflection.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.reflection.instantiation.VintageValueProvider;
import nl.jqno.equalsverifier.internal.reflection.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.util.Configuration;

public final class Context<T> {
    private final Class<T> type;
    private final Configuration<T> configuration;
    private final ClassProbe<T> classProbe;
    private final ValueProvider valueProvider;
    private final SubjectCreator<T> subjectCreator;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="FieldCache is inherently mutable")
    public Context(Configuration<T> configuration, PrefabValueProvider prefabValueProvider, GenericPrefabValueProvider.GenericFactories genericFactories, Objenesis objenesis) {
        this.type = configuration.getType();
        this.configuration = configuration;
        this.classProbe = new ClassProbe<T>(configuration.getType());
        FactoryCache cache = JavaApiPrefabValues.build();
        this.valueProvider = Context.configureValueProviders(cache, prefabValueProvider, genericFactories, objenesis);
        this.subjectCreator = new SubjectCreator<T>(configuration, this.valueProvider, objenesis);
    }

    private static ValueProvider configureValueProviders(FactoryCache factoryCache, PrefabValueProvider prefabValueProvider, GenericPrefabValueProvider.GenericFactories genericFactories, Objenesis objenesis) {
        ChainedValueProvider mainChain = new ChainedValueProvider(prefabValueProvider);
        ChainedValueProvider vintageChain = new ChainedValueProvider(prefabValueProvider);
        VintageValueProvider vintage = new VintageValueProvider(vintageChain, factoryCache, objenesis);
        GenericPrefabValueProvider genericPrefab = new GenericPrefabValueProvider(genericFactories, mainChain);
        mainChain.register(genericPrefab, vintage);
        vintageChain.register(genericPrefab);
        return mainChain;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Configuration<T> getConfiguration() {
        return this.configuration;
    }

    public ClassProbe<T> getClassProbe() {
        return this.classProbe;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="VintageValueProvider can use a mutable cache.")
    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public SubjectCreator<T> getSubjectCreator() {
        return this.subjectCreator;
    }
}

