/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.SuperclassIterable;
import nl.jqno.equalsverifier.internal.reflection.instantiation.GenericPrefabValueProvider;
import nl.jqno.equalsverifier.internal.reflection.instantiation.PrefabValueProvider;
import nl.jqno.equalsverifier.internal.reflection.vintage.ObjectAccessor;
import nl.jqno.equalsverifier.internal.util.Validations;

public final class PrefabValuesApi {
    private PrefabValuesApi() {
    }

    public static <T> void addPrefabValues(PrefabValueProvider provider, Objenesis objenesis, Class<T> otherType, T red, T blue) {
        Validations.validateRedAndBluePrefabValues(otherType, red, blue);
        if (red.getClass().isArray()) {
            provider.register(otherType, null, red, blue, red);
        } else {
            try {
                T redCopy = ObjectAccessor.of(red).copy(objenesis);
                provider.register(otherType, null, red, blue, redCopy);
            }
            catch (RuntimeException ignored) {
                provider.register(otherType, null, red, blue, red);
            }
        }
    }

    public static <T> void addPrefabValuesForField(PrefabValueProvider provider, Objenesis objenesis, Class<?> enclosingType, String fieldName, T red, T blue) {
        Field field = PrefabValuesApi.findField(enclosingType, fieldName);
        Class<?> type = field.getType();
        Validations.validateRedAndBluePrefabValues(type, red, blue);
        Validations.validateFieldTypeMatches(field, red.getClass());
        if (type.isArray()) {
            provider.register(type, fieldName, red, blue, red);
        } else {
            try {
                T redCopy = ObjectAccessor.of(red).copy(objenesis);
                provider.register(type, fieldName, red, blue, redCopy);
            }
            catch (RuntimeException ignored) {
                provider.register(type, fieldName, red, blue, red);
            }
        }
    }

    private static Field findField(Class<?> type, String fieldName) {
        for (Class<?> c : SuperclassIterable.ofIncludeSelf(type)) {
            try {
                return c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        throw new IllegalStateException("Precondition: class " + type.getSimpleName() + " does not contain field " + fieldName + ".");
    }

    public static <T> void addGenericPrefabValues(GenericPrefabValueProvider.GenericFactories factories, Class<T> otherType, Func.Func1<?, T> factory) {
        Validations.validateNotNull(factory, "factory is null.");
        Validations.validateGenericPrefabValues(otherType, 1);
        factories.register(otherType, factory);
    }

    public static <T> void addGenericPrefabValues(GenericPrefabValueProvider.GenericFactories factories, Class<T> otherType, Func.Func2<?, ?, T> factory) {
        Validations.validateNotNull(factory, "factory is null.");
        Validations.validateGenericPrefabValues(otherType, 2);
        factories.register(otherType, factory);
    }
}

