/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.api.EqualsVerifierApi;
import nl.jqno.equalsverifier.api.MultipleTypeEqualsVerifierApi;
import nl.jqno.equalsverifier.api.SingleTypeEqualsVerifierApi;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.instantiation.vintage.PrefabValuesApi;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.lib.objenesis.ObjenesisStd;
import nl.jqno.equalsverifier.internal.reflection.PackageScanner;
import nl.jqno.equalsverifier.internal.util.ListBuilders;
import nl.jqno.equalsverifier.internal.util.Validations;

public final class ConfiguredEqualsVerifier
implements EqualsVerifierApi<Void> {
    private final EnumSet<Warning> warningsToSuppress;
    private final FactoryCache factoryCache;
    private boolean usingGetClass;
    private Function<String, String> fieldnameToGetter;
    private final Objenesis objenesis = new ObjenesisStd();

    public ConfiguredEqualsVerifier() {
        this(EnumSet.noneOf(Warning.class), new FactoryCache(), false, null);
    }

    private ConfiguredEqualsVerifier(EnumSet<Warning> warningsToSuppress, FactoryCache factoryCache, boolean usingGetClass, Function<String, String> fieldnameToGetter) {
        this.warningsToSuppress = warningsToSuppress;
        this.factoryCache = factoryCache;
        this.usingGetClass = usingGetClass;
        this.fieldnameToGetter = fieldnameToGetter;
    }

    public ConfiguredEqualsVerifier copy() {
        return new ConfiguredEqualsVerifier(EnumSet.copyOf(this.warningsToSuppress), this.factoryCache.copy(), this.usingGetClass, this.fieldnameToGetter);
    }

    public ConfiguredEqualsVerifier suppress(Warning ... warnings) {
        Collections.addAll(this.warningsToSuppress, warnings);
        return this;
    }

    public <S> ConfiguredEqualsVerifier withPrefabValues(Class<S> otherType, S red, S blue) {
        PrefabValuesApi.addPrefabValues(this.factoryCache, this.objenesis, otherType, red, blue);
        return this;
    }

    public <S> ConfiguredEqualsVerifier withGenericPrefabValues(Class<S> otherType, Func.Func1<?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    public <S> ConfiguredEqualsVerifier withGenericPrefabValues(Class<S> otherType, Func.Func2<?, ?, S> factory) {
        PrefabValuesApi.addGenericPrefabValues(this.factoryCache, otherType, factory);
        return this;
    }

    public ConfiguredEqualsVerifier usingGetClass() {
        this.usingGetClass = true;
        return this;
    }

    public ConfiguredEqualsVerifier withFieldnameToGetterConverter(Function<String, String> converter) {
        this.fieldnameToGetter = converter;
        return this;
    }

    @Deprecated
    public ConfiguredEqualsVerifier withResetCaches() {
        return this;
    }

    public <T> SingleTypeEqualsVerifierApi<T> forClass(Class<T> type) {
        return new SingleTypeEqualsVerifierApi<T>(type, EnumSet.copyOf(this.warningsToSuppress), this.factoryCache.copy(), this.objenesis, this.usingGetClass, this.fieldnameToGetter);
    }

    public MultipleTypeEqualsVerifierApi forClasses(Iterable<Class<?>> classes) {
        return new MultipleTypeEqualsVerifierApi(ListBuilders.fromIterable(classes), this);
    }

    public MultipleTypeEqualsVerifierApi forClasses(Class<?> first, Class<?> second, Class<?> ... more) {
        return new MultipleTypeEqualsVerifierApi(ListBuilders.buildListOfAtLeastTwo(first, second, more), this);
    }

    public MultipleTypeEqualsVerifierApi forPackage(String packageName) {
        return this.forPackage(packageName, false);
    }

    public MultipleTypeEqualsVerifierApi forPackage(String packageName, boolean scanRecursively) {
        List<Class<?>> classes = PackageScanner.getClassesIn(packageName, null, scanRecursively);
        Validations.validatePackageContainsClasses(packageName, classes);
        return new MultipleTypeEqualsVerifierApi(classes, this);
    }

    public MultipleTypeEqualsVerifierApi forPackage(String packageName, Class<?> mustExtend) {
        List<Class<?>> classes = PackageScanner.getClassesIn(packageName, mustExtend, true);
        Validations.validatePackageContainsClasses(packageName, classes);
        return new MultipleTypeEqualsVerifierApi(classes, this);
    }
}

