/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class AbstractDelegationChecker<T>
implements Checker {
    private final Class<T> type;
    private final TypeTag typeTag;
    private final SubjectCreator<T> subjectCreator;
    private final ValueProvider valueProvider;
    private final ClassProbe<T> classProbe;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public AbstractDelegationChecker(Context<T> context) {
        Configuration<T> config = context.getConfiguration();
        this.type = context.getType();
        this.typeTag = config.getTypeTag();
        this.subjectCreator = context.getSubjectCreator();
        this.valueProvider = context.getValueProvider();
        this.classProbe = context.getClassProbe();
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
    }

    @Override
    public void check() {
        this.checkAbstractEqualsAndHashCode();
        this.checkAbstractDelegationInFields();
        T instance = this.subjectCreator.plain();
        T copy = this.subjectCreator.plain();
        this.checkAbstractDelegation(instance, copy);
    }

    private void checkAbstractEqualsAndHashCode() {
        boolean equalsIsAbstract = this.classProbe.isEqualsAbstract();
        boolean hashCodeIsAbstract = this.classProbe.isHashCodeAbstract();
        if (equalsIsAbstract && hashCodeIsAbstract) {
            Assert.fail(Formatter.of("Abstract delegation: %%'s equals and hashCode methods are both abstract. They should be concrete.", this.type.getSimpleName()));
        } else if (equalsIsAbstract) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(this.type, true, true));
        } else if (hashCodeIsAbstract) {
            Assert.fail(this.buildSingleAbstractMethodErrorMessage(this.type, false, true));
        }
    }

    private void checkAbstractDelegationInFields() {
        for (Field field : FieldIterable.of(this.type)) {
            TypeTag tag = TypeTag.of(field, this.typeTag);
            Tuple tuple = this.safelyGetTuple(tag);
            if (tuple == null) continue;
            Object instance = tuple.getRed();
            Object copy = tuple.getBlue();
            this.checkAbstractMethods(tag.getType(), instance, copy, true);
        }
    }

    private <U> Tuple<U> safelyGetTuple(TypeTag tag) {
        try {
            return this.valueProvider.provideOrThrow(tag);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void checkAbstractDelegation(T instance, T copy) {
        this.checkAbstractMethods(this.type, instance, copy, false);
    }

    private Formatter buildSingleAbstractMethodErrorMessage(Class<?> c, boolean isEqualsAbstract, boolean bothShouldBeConcrete) {
        return Formatter.of("Abstract delegation: %%'s %% method is abstract, but %% is not.\n%%", c.getSimpleName(), isEqualsAbstract ? "equals" : "hashCode", isEqualsAbstract ? "hashCode" : "equals", bothShouldBeConcrete ? "Both should be concrete." : "Both should be either abstract or concrete.");
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="These exceptions will re-occur and be handled later.")
    private <S> void checkAbstractMethods(Class<?> instanceClass, S instance, S copy, boolean prefabPossible) {
        Formatter f;
        try {
            instance.equals(copy);
        }
        catch (AbstractMethodError e) {
            f = this.buildAbstractDelegationErrorMessage(instanceClass, prefabPossible, "equals", e.getMessage());
            Assert.fail(f, e);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.cachedHashCodeInitializer.getInitializedHashCode(instance);
        }
        catch (AbstractMethodError e) {
            f = this.buildAbstractDelegationErrorMessage(instanceClass, prefabPossible, "hashCode", e.getMessage());
            Assert.fail(f, e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Formatter buildAbstractDelegationErrorMessage(Class<?> c, boolean prefabPossible, String method, String originalMessage) {
        Formatter prefabFormatter = Formatter.of("\nAdd prefab values for %%.", c.getName());
        return Formatter.of("Abstract delegation: %%'s %% method delegates to an abstract method:\n %%%%", c.getSimpleName(), method, originalMessage, prefabPossible ? prefabFormatter.format() : "");
    }
}

