/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldMutator;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.RecordProbe;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;

public class InstanceCreator<T> {
    private final Class<T> type;
    private final ClassProbe<T> probe;
    private final Instantiator<T> instantiator;

    public InstanceCreator(ClassProbe<T> probe, Objenesis objenesis) {
        this.type = probe.getType();
        this.probe = probe;
        this.instantiator = Instantiator.of(this.type, objenesis);
    }

    public T instantiate(Map<Field, Object> values) {
        return this.probe.isRecord() ? this.createRecordInstance(values) : this.createClassInstance(values);
    }

    public T copy(Object original) {
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        for (Field f : this.fields(original.getClass())) {
            Object value = FieldProbe.of(f).getValue(original);
            values.put(f, value);
        }
        return this.instantiate(values);
    }

    private T createRecordInstance(Map<Field, Object> values) {
        ArrayList params = new ArrayList();
        this.traverseFields(values, (f, v) -> params.add(v));
        RecordProbe<T> recordProbe = new RecordProbe<T>(this.type);
        return recordProbe.callRecordConstructor(params);
    }

    private T createClassInstance(Map<Field, Object> values) {
        Object instance = this.instantiator.instantiate();
        this.traverseFields(values, (f, v) -> new FieldMutator(FieldProbe.of(f)).setNewValue(instance, v));
        return instance;
    }

    private void traverseFields(Map<Field, Object> values, BiConsumer<Field, Object> setValue) {
        for (Field f : this.fields(this.type)) {
            Object value = values.get(f);
            if (value == null) {
                value = PrimitiveMappers.DEFAULT_VALUE_MAPPER.get(f.getType());
            }
            setValue.accept(f, value);
        }
    }

    private FieldIterable fields(Class<?> typeWithFields) {
        return FieldIterable.ofIgnoringStatic(typeWithFields);
    }
}

