/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.vintage.reflection;

import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.instantiation.vintage.VintageValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.reflection.InPlaceObjectAccessor;
import nl.jqno.equalsverifier.internal.instantiation.vintage.reflection.RecordObjectAccessor;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.RecordsHelper;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;

public abstract class ObjectAccessor<T> {
    private final T object;
    private final Class<T> type;

    ObjectAccessor(T object, Class<T> type) {
        this.object = object;
        this.type = type;
    }

    public static <T> ObjectAccessor<T> of(T object) {
        Class<?> type = object.getClass();
        return ObjectAccessor.of(object, type);
    }

    public static <T> ObjectAccessor<T> of(T object, Class<T> type) {
        if (RecordsHelper.isRecord(type)) {
            return new RecordObjectAccessor<T>(object, type);
        }
        return new InPlaceObjectAccessor<T>(object, type);
    }

    public T get() {
        return this.object;
    }

    public Class<T> type() {
        return this.type;
    }

    public abstract T copy(Objenesis var1);

    public abstract ObjectAccessor<T> scramble(VintageValueProvider var1, TypeTag var2, LinkedHashSet<TypeTag> var3);
}

