/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.vintage.reflection;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.internal.instantiation.vintage.VintageValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.RecordProbe;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;

final class RecordObjectAccessor<T>
extends ObjectAccessor<T> {
    private final RecordProbe<T> probe;

    RecordObjectAccessor(T object, Class<T> type) {
        super(object, type);
        this.probe = new RecordProbe<T>(type);
    }

    @Override
    public T copy(Objenesis objenesis) {
        List params = this.probe.fields().map(this::getField).collect(Collectors.toList());
        return this.callRecordConstructor(params);
    }

    @Override
    public ObjectAccessor<T> scramble(VintageValueProvider valueProvider, TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack) {
        return this.makeAccessor(f -> {
            T value = this.getField((Field)f);
            TypeTag tag = TypeTag.of(f, enclosingType);
            return valueProvider.giveOther(tag, value, typeStack);
        });
    }

    private ObjectAccessor<T> makeAccessor(Function<Field, Object> determineValue) {
        List params = this.probe.fields().map(determineValue).collect(Collectors.toList());
        T newObject = this.callRecordConstructor(params);
        return ObjectAccessor.of(newObject);
    }

    private T callRecordConstructor(List<?> params) {
        RecordProbe p = new RecordProbe(this.type());
        return p.callRecordConstructor(params);
    }

    public T getField(Field field) {
        return (T)FieldProbe.of(field).getValue(this.get());
    }
}

