/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public final class FieldProbe {
    private final Field field;

    private FieldProbe(Field field) {
        this.field = field;
    }

    public static FieldProbe of(Field field) {
        return new FieldProbe(field);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Can't defensively copy a Field.")
    public Field getField() {
        return this.field;
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Only called in test code, not production.")
    public Object getValue(Object object) {
        this.field.setAccessible(true);
        return Rethrow.rethrow(() -> this.field.get(object));
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    public boolean isEmptyOrSingleValueEnum() {
        Class<?> type = this.field.getType();
        return type.isEnum() && type.getEnumConstants().length <= 1;
    }

    public boolean canBeDefault(Configuration<?> config) {
        if (this.isPrimitive()) {
            return !config.getPrefabbedFields().contains(this.getName());
        }
        boolean isAnnotated = this.isAnnotatedNonnull(config.getAnnotationCache());
        boolean isMentionedExplicitly = config.getNonnullFields().contains(this.field.getName());
        return !config.getWarningsToSuppress().contains((Object)Warning.NULL_FIELDS) && !isAnnotated && !isMentionedExplicitly;
    }

    public boolean isAnnotatedNonnull(AnnotationCache annotationCache) {
        Class<?> type = this.field.getDeclaringClass();
        if (annotationCache.hasFieldAnnotation(type, this.field.getName(), SupportedAnnotations.NONNULL)) {
            return true;
        }
        if (annotationCache.hasFieldAnnotation(type, this.field.getName(), SupportedAnnotations.NULLABLE)) {
            return false;
        }
        boolean hasFindbugsAnnotation = annotationCache.hasClassAnnotation(type, SupportedAnnotations.FINDBUGS1X_DEFAULT_ANNOTATION_NONNULL);
        boolean hasJsr305Annotation = annotationCache.hasClassAnnotation(type, SupportedAnnotations.JSR305_DEFAULT_ANNOTATION_NONNULL);
        boolean hasDefaultAnnotation = annotationCache.hasClassAnnotation(type, SupportedAnnotations.DEFAULT_ANNOTATION_NONNULL);
        return hasFindbugsAnnotation || hasJsr305Annotation || hasDefaultAnnotation;
    }

    public boolean canBeModifiedReflectively() {
        if (this.field.isSynthetic()) {
            return false;
        }
        return !this.isFinal() || !this.isStatic();
    }
}

