/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.annotations;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import nl.jqno.equalsverifier.internal.reflection.Util;
import nl.jqno.equalsverifier.internal.reflection.annotations.Annotation;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCacheBuilder;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationProperties;

public enum SupportedAnnotations implements Annotation
{
    IMMUTABLE(false, "Immutable"),
    NONNULL(true, "Nonnull", "NonNull", "NotNull"),
    NULLABLE(false, "Nullable", "CheckForNull"),
    FINDBUGS1X_DEFAULT_ANNOTATION_NONNULL(false, new String[]{"edu.umd.cs.findbugs.annotations.DefaultAnnotation", "edu.umd.cs.findbugs.annotations.DefaultAnnotationForFields"}){

        @Override
        public boolean validate(AnnotationProperties properties, AnnotationCache annotationCache, Set<String> ignoredAnnotations) {
            Set<String> values = properties.getArrayValues("value");
            for (String value : values) {
                for (String className : NONNULL.partialClassNames()) {
                    if (!value.contains(className) || ignoredAnnotations.contains(value)) continue;
                    return true;
                }
            }
            return false;
        }
    }
    ,
    JSR305_DEFAULT_ANNOTATION_NONNULL(false, new String[]{""}){

        @Override
        public boolean validate(AnnotationProperties properties, AnnotationCache annotationCache, Set<String> ignoredAnnotations) {
            try {
                Class annotationType = Util.classForName(properties.getClassName());
                if (annotationType == null) {
                    return false;
                }
                AnnotationCacheBuilder builder = new AnnotationCacheBuilder(new Annotation[]{NONNULL, JSR305_TYPE_QUALIFIER_DEFAULT}, ignoredAnnotations);
                builder.build(annotationType, annotationCache);
                boolean hasNonnullAnnotation = annotationCache.hasClassAnnotation(annotationType, NONNULL);
                boolean hasValidTypeQualifierDefault = annotationCache.hasClassAnnotation(annotationType, JSR305_TYPE_QUALIFIER_DEFAULT);
                return hasNonnullAnnotation && hasValidTypeQualifierDefault;
            }
            catch (UnsupportedClassVersionError ignored) {
                return false;
            }
        }
    }
    ,
    JSR305_TYPE_QUALIFIER_DEFAULT(false, new String[]{"javax.annotation.meta.TypeQualifierDefault"}){

        @Override
        public boolean validate(AnnotationProperties properties, AnnotationCache annotationCache, Set<String> ignoredAnnotations) {
            Set<String> value = properties.getArrayValues("value");
            return value.contains("FIELD") || value.contains("PARAMETER");
        }
    }
    ,
    DEFAULT_ANNOTATION_NONNULL(false, new String[]{"org.eclipse.jdt.annotation.NonNullByDefault", "org.jspecify.annotations.NullMarked", "org.springframework.lang.NonNullFields"}){

        @Override
        public boolean validate(AnnotationProperties properties, AnnotationCache annotationCache, Set<String> ignoredAnnotations) {
            if (properties.getClassName().endsWith("NullMarked")) {
                return true;
            }
            Set<String> values = properties.getArrayValues("value");
            if (values == null) {
                return true;
            }
            for (String value : values) {
                if (!"FIELD".equals(value)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    ENTITY(false, "javax.persistence.Entity", "javax.persistence.Embeddable", "javax.persistence.MappedSuperclass", "jakarta.persistence.Entity", "jakarta.persistence.Embeddable", "jakarta.persistence.MappedSuperclass"),
    TRANSIENT(true, "javax.persistence.Transient", "jakarta.persistence.Transient"),
    ID(true, new String[]{"javax.persistence.Id", "javax.persistence.EmbeddedId", "jakarta.persistence.Id", "jakarta.persistence.EmbeddedId"}){

        @Override
        public void postProcess(Set<Class<?>> types, AnnotationCache annotationCache) {
            types.forEach(t -> annotationCache.addClassAnnotation((Class<?>)t, ID));
        }
    }
    ,
    NATURALID(false, new String[]{"org.hibernate.annotations.NaturalId"}){

        @Override
        public void postProcess(Set<Class<?>> types, AnnotationCache annotationCache) {
            types.forEach(t -> annotationCache.addClassAnnotation((Class<?>)t, NATURALID));
        }
    }
    ,
    JPA_LINKED_FIELD(true, "javax.persistence.OneToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToOne", "javax.persistence.ManyToMany", "javax.persistence.ElementCollection", "javax.persistence.GeneratedValue", "jakarta.persistence.OneToOne", "jakarta.persistence.OneToMany", "jakarta.persistence.ManyToOne", "jakarta.persistence.ManyToMany", "jakarta.persistence.ElementCollection", "jakarta.persistence.GeneratedValue"),
    JPA_LAZY_FIELD(true, new String[]{"javax.persistence.Basic", "jakarta.persistence.Basic"}){

        @Override
        public boolean validate(AnnotationProperties properties, AnnotationCache annotationCache, Set<String> ignoredAnnotations) {
            return "LAZY".equals(properties.getEnumValue("fetch"));
        }
    };

    private final boolean inherits;
    private final Set<String> partialClassNames;

    private SupportedAnnotations(boolean inherits, String ... partialClassNames) {
        this.inherits = inherits;
        this.partialClassNames = new HashSet<String>();
        this.partialClassNames.addAll(Arrays.asList(partialClassNames));
    }

    @Override
    public Set<String> partialClassNames() {
        return Collections.unmodifiableSet(this.partialClassNames);
    }

    @Override
    public boolean inherits() {
        return this.inherits;
    }
}

