/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.ListBuilders;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;

public final class Validations {
    private Validations() {
    }

    public static void validateClassCanBeVerified(Class<?> type) {
        Validations.validate(ArrayList.class.isAssignableFrom(type), "EqualsVerfifier cannot verify subclasses of java.util.ArrayList: its invariants are too complex for EqualsVerifier to maintain.");
    }

    public static void validateFieldNamesExist(Class<?> type, List<String> givenFields, Set<String> actualFields) {
        givenFields.forEach(f -> Validations.validateFieldNameExists(type, f, actualFields));
    }

    public static void validateFieldNameExists(Class<?> type, String field, Set<String> actualFields) {
        Validations.validate(!actualFields.contains(field), "class " + type.getSimpleName() + " does not contain field " + field + ".");
    }

    public static void validateWarnings(Set<Warning> warnings) {
        Validations.validate(warnings.contains((Object)Warning.SURROGATE_KEY) && warnings.contains((Object)Warning.SURROGATE_OR_BUSINESS_KEY), "you can't suppress Warning.SURROGATE_KEY when Warning.SURROGATE_OR_BUSINESS_KEY is also suppressed.");
    }

    public static void validateFields(Set<String> includedFields, Set<String> excludedFields) {
        Validations.validate(!includedFields.isEmpty() && !excludedFields.isEmpty(), "you can call either withOnlyTheseFields or withIgnoredFields, but not both.");
    }

    public static void validateNonnullFields(Set<String> nonnullFields, Set<Warning> warnings) {
        Validations.validate(!nonnullFields.isEmpty() && warnings.contains((Object)Warning.NULL_FIELDS), "you can call either withNonnullFields or suppress Warning.NULL_FIELDS, but not both.");
    }

    public static <T> void validateUnequalExamples(List<T> unequalExamples, List<T> equalExamples) {
        Validations.validate(ListBuilders.listContainsDuplicates(unequalExamples), "two objects are equal to each other.");
        unequalExamples.forEach(u -> Validations.validateExampleIsUnequal(u, equalExamples));
    }

    private static <T> void validateExampleIsUnequal(T example, List<T> equalExamples) {
        Validations.validate(equalExamples.contains(example), "an equal example also appears as unequal example.");
    }

    public static <T> void validateRedAndBluePrefabValues(Class<T> type, T red, T blue) {
        Validations.validateNotNull(type, "prefab value type is null.");
        Validations.validateNotNull(red, "red prefab value of type " + type.getSimpleName() + " is null.");
        Validations.validateNotNull(blue, "blue prefab value of type " + type.getSimpleName() + " is null.");
        Validations.validate(red.equals(blue), "both prefab values of type " + type.getSimpleName() + " are equal.");
    }

    public static <T> void validateFieldTypeMatches(Class<T> container, String fieldName, Class<?> fieldType) {
        try {
            Field f = container.getDeclaredField(fieldName);
            boolean typeCompatible = f.getType().isAssignableFrom(fieldType);
            boolean wrappingCompatible = fieldType.equals(PrimitiveMappers.PRIMITIVE_OBJECT_MAPPER.get(f.getType()));
            Validations.validate(!typeCompatible && !wrappingCompatible, "Prefab values for field " + fieldName + " should be of type " + f.getType().getSimpleName() + " but are " + fieldType.getSimpleName() + ".");
        }
        catch (NoSuchFieldException e) {
            Validations.validate(false, "Class " + container.getSimpleName() + " has no field named " + fieldName + ".");
        }
    }

    public static <T> void validateGenericPrefabValues(Class<T> type, PrefabValueFactory<T> factory, int arity) {
        Validations.validateNotNull(type, "type is null.");
        int n = type.getTypeParameters().length;
        String message = "number of generic type parameters doesn't match:\n  " + type.getName() + " has " + n + "\n  Factory has " + arity;
        Validations.validate(n != arity, message);
    }

    public static void validateWarningsAndFields(Set<Warning> warnings, Set<String> includedFields, Set<String> excludedFields) {
        boolean hasSurrogateKey = warnings.contains((Object)Warning.SURROGATE_KEY);
        boolean usesWithOnlyTheseFields = !includedFields.isEmpty();
        boolean usesWithIgnoredFields = !excludedFields.isEmpty();
        Validations.validate(hasSurrogateKey && usesWithOnlyTheseFields, "you can't use withOnlyTheseFields when Warning.SURROGATE_KEY is suppressed.\nYou can remove withOnlyTheseFields.");
        Validations.validate(hasSurrogateKey && usesWithIgnoredFields, "you can't use withIgnoredFields when Warning.SURROGATE_KEY is suppressed.\nYou can remove withIgnoredFields.");
    }

    public static void validateGivenAnnotations(Class<?> ... givenAnnotations) {
        Arrays.stream(givenAnnotations).forEach(a -> Validations.validateIsAnnotation(a));
    }

    private static void validateIsAnnotation(Class<?> type) {
        Validations.validate(!type.isAnnotation(), "class " + type.getCanonicalName() + " is not an annotation.");
    }

    public static void validateProcessedAnnotations(Class<?> type, AnnotationCache cache, Set<Warning> warnings, Set<String> includedFields, Set<String> excludedFields) {
        Validations.validateClassAnnotations(type, cache, warnings, includedFields, excludedFields);
        Validations.validateFieldAnnotations(type, cache, warnings, includedFields);
    }

    private static void validateClassAnnotations(Class<?> type, AnnotationCache cache, Set<Warning> warnings, Set<String> includedFields, Set<String> excludedFields) {
        boolean usesWithOnlyTheseFields = !includedFields.isEmpty();
        boolean usesWithIgnoredFields = !excludedFields.isEmpty();
        boolean hasNaturalId = cache.hasClassAnnotation(type, SupportedAnnotations.NATURALID);
        boolean hasSurrogateKey = warnings.contains((Object)Warning.SURROGATE_KEY);
        boolean hasVersionedEntity = warnings.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY);
        Validations.validate(hasNaturalId && usesWithOnlyTheseFields, "you can't use withOnlyTheseFields when fields are marked with @NaturalId.");
        Validations.validate(hasNaturalId && usesWithIgnoredFields, "you can't use withIgnoredFields when fields are marked with @NaturalId.");
        Validations.validate(hasNaturalId && hasSurrogateKey, "you can't suppress Warning.SURROGATE_KEY when fields are marked @NaturalId.");
        Validations.validate(hasNaturalId && hasVersionedEntity, "you can't suppress Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY when fields are marked with @NaturalId.");
    }

    private static void validateFieldAnnotations(Class<?> type, AnnotationCache cache, Set<Warning> warnings, Set<String> includedFields) {
        FieldIterable.of(type).forEach(f -> Validations.validateFieldAnnotation(type, f, cache, warnings, includedFields));
    }

    private static void validateFieldAnnotation(Class<?> type, Field f, AnnotationCache cache, Set<Warning> warnings, Set<String> includedFields) {
        Validations.validate(includedFields.contains(f.getName()) && cache.hasFieldAnnotation(type, f.getName(), SupportedAnnotations.ID) && !warnings.contains((Object)Warning.SURROGATE_OR_BUSINESS_KEY), "you can't use withOnlyTheseFields on a field marked @Id or @EmbeddedId.\nSuppress Warning.SURROGATE_KEY and remove withOnlyTheseFields if you want to use only the @Id or @EmbeddedId fields in equals.");
    }

    public static void validatePackageContainsClasses(String packageName, List<Class<?>> types) {
        Validations.validate(types.size() == 0, "package " + packageName + " doesn't contain any (non-Test) types.");
    }

    public static void validateTypesAreKnown(List<Class<?>> types, List<Class<?>> knownTypes) {
        List unknownTypes = types.stream().filter(t -> !knownTypes.contains(t)).collect(Collectors.toList());
        String message = "Unknown class(es) found: " + unknownTypes.stream().map(t -> t.getCanonicalName()).collect(Collectors.joining(", "));
        Validations.validate(!unknownTypes.isEmpty(), message);
    }

    public static void validateNotNull(Object object, String errormessage) {
        if (object == null) {
            throw new NullPointerException("Precondition: " + errormessage);
        }
    }

    private static void validate(boolean condition, String errorMessage) {
        if (condition) {
            throw new IllegalStateException("Precondition: " + errorMessage);
        }
    }
}

