/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.util.function.Predicate;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.checkers.FieldInspector;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.ArrayFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.BigDecimalFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FloatAndDoubleFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.JpaLazyGetterFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.MutableStateFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.ReflexivityFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.SignificantFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.StringFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.SymmetryFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.TransientFieldsCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.TransitivityFieldCheck;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.reflection.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Context;

public class FieldsChecker<T>
implements Checker {
    private final Context<T> context;
    private final Configuration<T> config;
    private final ArrayFieldCheck<T> arrayFieldCheck;
    private final FloatAndDoubleFieldCheck<T> floatAndDoubleFieldCheck;
    private final MutableStateFieldCheck<T> mutableStateFieldCheck;
    private final ReflexivityFieldCheck<T> reflexivityFieldCheck;
    private final SignificantFieldCheck<T> significantFieldCheck;
    private final SymmetryFieldCheck<T> symmetryFieldCheck;
    private final TransientFieldsCheck<T> transientFieldsCheck;
    private final TransitivityFieldCheck<T> transitivityFieldCheck;
    private final StringFieldCheck<T> stringFieldCheck;
    private final BigDecimalFieldCheck<T> bigDecimalFieldCheck;
    private final JpaLazyGetterFieldCheck<T> jpaLazyGetterFieldCheck;

    public FieldsChecker(Context<T> context) {
        this.context = context;
        this.config = context.getConfiguration();
        TypeTag typeTag = this.config.getTypeTag();
        SubjectCreator<T> subjectCreator = context.getSubjectCreator();
        String cachedHashCodeFieldName = this.config.getCachedHashCodeInitializer().getCachedHashCodeFieldName();
        Predicate<FieldProbe> isCachedHashCodeField = p -> p.getName().equals(cachedHashCodeFieldName);
        this.arrayFieldCheck = new ArrayFieldCheck<T>(subjectCreator, this.config.getCachedHashCodeInitializer());
        this.floatAndDoubleFieldCheck = new FloatAndDoubleFieldCheck<T>(subjectCreator);
        this.mutableStateFieldCheck = new MutableStateFieldCheck<T>(subjectCreator, isCachedHashCodeField);
        this.reflexivityFieldCheck = new ReflexivityFieldCheck<T>(context);
        this.significantFieldCheck = new SignificantFieldCheck<T>(context, isCachedHashCodeField);
        this.symmetryFieldCheck = new SymmetryFieldCheck<T>(subjectCreator);
        this.transientFieldsCheck = new TransientFieldsCheck<T>(subjectCreator, typeTag, this.config.getAnnotationCache());
        this.transitivityFieldCheck = new TransitivityFieldCheck<T>(subjectCreator);
        this.stringFieldCheck = new StringFieldCheck<T>(subjectCreator, context.getValueProvider(), this.config.getCachedHashCodeInitializer());
        this.bigDecimalFieldCheck = new BigDecimalFieldCheck<T>(subjectCreator, this.config.getCachedHashCodeInitializer());
        this.jpaLazyGetterFieldCheck = new JpaLazyGetterFieldCheck<T>(context);
    }

    @Override
    public void check() {
        AnnotationCache cache;
        FieldInspector<T> inspector = new FieldInspector<T>(this.context.getType());
        if (!this.context.getClassProbe().isEqualsInheritedFromObject()) {
            inspector.check(this.arrayFieldCheck);
            inspector.check(this.floatAndDoubleFieldCheck);
            inspector.check(this.reflexivityFieldCheck);
        }
        if (!this.ignoreMutability(this.context.getType())) {
            inspector.check(this.mutableStateFieldCheck);
        }
        if (!this.config.getWarningsToSuppress().contains((Object)Warning.TRANSIENT_FIELDS)) {
            inspector.check(this.transientFieldsCheck);
        }
        inspector.check(this.significantFieldCheck);
        inspector.check(this.symmetryFieldCheck);
        inspector.check(this.transitivityFieldCheck);
        inspector.check(this.stringFieldCheck);
        if (!this.config.getWarningsToSuppress().contains((Object)Warning.BIGDECIMAL_EQUALITY)) {
            inspector.check(this.bigDecimalFieldCheck);
        }
        if ((cache = this.config.getAnnotationCache()).hasClassAnnotation(this.config.getType(), SupportedAnnotations.ENTITY) && !this.config.getWarningsToSuppress().contains((Object)Warning.JPA_GETTER)) {
            inspector.check(this.jpaLazyGetterFieldCheck);
        }
    }

    private boolean ignoreMutability(Class<?> type) {
        AnnotationCache cache = this.config.getAnnotationCache();
        return this.config.getWarningsToSuppress().contains((Object)Warning.NONFINAL_FIELDS) || cache.hasClassAnnotation(type, SupportedAnnotations.IMMUTABLE) || cache.hasClassAnnotation(type, SupportedAnnotations.ENTITY);
    }
}

