/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.reflection.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class TransientFieldsCheck<T>
implements FieldCheck<T> {
    private final SubjectCreator<T> subjectCreator;
    private final TypeTag typeTag;
    private final AnnotationCache annotationCache;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="A cache is inherently mutable.")
    public TransientFieldsCheck(SubjectCreator<T> subjectCreator, TypeTag typeTag, AnnotationCache annotationCache) {
        this.subjectCreator = subjectCreator;
        this.typeTag = typeTag;
        this.annotationCache = annotationCache;
    }

    @Override
    public void execute(FieldProbe fieldProbe) {
        boolean fieldIsTransient;
        T changed;
        T reference = this.subjectCreator.plain();
        boolean equalsChanged = !reference.equals(changed = this.subjectCreator.withFieldChanged(fieldProbe.getField()));
        boolean hasAnnotation = this.annotationCache.hasFieldAnnotation(this.typeTag.getType(), fieldProbe.getName(), SupportedAnnotations.TRANSIENT);
        boolean bl = fieldIsTransient = fieldProbe.isTransient() || hasAnnotation;
        if (equalsChanged && fieldIsTransient) {
            Assert.fail(Formatter.of("Transient field %% should not be included in equals/hashCode contract.", fieldProbe.getName()));
        }
    }
}

