/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.objenesis.strategy;

import nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.ObjectInstantiator;
import nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.android.Android10Instantiator;
import nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.android.Android17Instantiator;
import nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.android.Android18Instantiator;
import nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.gcj.GCJInstantiator;
import nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.perc.PercInstantiator;
import nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.sun.SunReflectionFactoryInstantiator;
import nl.jqno.equalsverifier.internal.lib.objenesis.instantiator.sun.UnsafeFactoryInstantiator;
import nl.jqno.equalsverifier.internal.lib.objenesis.strategy.BaseInstantiatorStrategy;
import nl.jqno.equalsverifier.internal.lib.objenesis.strategy.PlatformDescription;

public class StdInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (PlatformDescription.isThisJVM("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new UnsafeFactoryInstantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 10) {
                return new Android10Instantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 17) {
                return new Android17Instantiator<T>(type);
            }
            return new Android18Instantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("GNU libgcj")) {
            return new GCJInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("PERC")) {
            return new PercInstantiator<T>(type);
        }
        return new UnsafeFactoryInstantiator<T>(type);
    }
}

