/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.reflection.Util;

public class ConditionalInstantiator {
    private final String fullyQualifiedClassName;
    private final boolean throwExceptions;

    public ConditionalInstantiator(String fullyQualifiedClassName) {
        this(fullyQualifiedClassName, true);
    }

    public ConditionalInstantiator(String fullyQualifiedClassName, boolean throwExceptions) {
        this.fullyQualifiedClassName = fullyQualifiedClassName;
        this.throwExceptions = throwExceptions;
    }

    public <T> Class<T> resolve() {
        return Util.classForName(this.fullyQualifiedClassName);
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="EV is run only from within unit tests")
    public <T> T instantiate(Class<?>[] paramTypes, Object[] paramValues) {
        try {
            Class<T> type = this.resolve();
            if (type == null) {
                return null;
            }
            Constructor<T> c = type.getConstructor(paramTypes);
            c.setAccessible(true);
            return c.newInstance(paramValues);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public <T> T callFactory(String factoryMethod, Class<?>[] paramTypes, Object[] paramValues) {
        return this.callFactory(this.fullyQualifiedClassName, factoryMethod, paramTypes, paramValues);
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="EV is run only from within unit tests")
    public <T> T callFactory(String factoryTypeName, String factoryMethod, Class<?>[] paramTypes, Object[] paramValues) {
        try {
            Class<T> type = this.resolve();
            if (type == null) {
                return null;
            }
            Class<?> factoryType = Class.forName(factoryTypeName);
            Method factory = factoryType.getMethod(factoryMethod, paramTypes);
            factory.setAccessible(true);
            return (T)factory.invoke(null, paramValues);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="EV is run only from within unit tests")
    public <T> T returnConstant(String constantName) {
        try {
            Class<T> type = this.resolve();
            if (type == null) {
                return null;
            }
            Field field = type.getField(constantName);
            field.setAccessible(true);
            return (T)field.get(null);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    private <T> T handleException(Exception e) {
        if (this.throwExceptions) {
            throw new ReflectionException(e);
        }
        return null;
    }
}

