/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.reflection.Util;

public final class TypeTag {
    public static final TypeTag NULL = new TypeTag(NullType.class, new TypeTag[0]);
    private final Class<?> type;
    private final List<TypeTag> genericTypes;

    public TypeTag(Class<?> type, TypeTag ... genericTypes) {
        this(type, Arrays.asList(genericTypes));
    }

    private TypeTag(Class<?> type, List<TypeTag> genericTypes) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
        this.genericTypes = genericTypes;
    }

    public static TypeTag of(Field field, TypeTag enclosingType) {
        return TypeTag.resolve(field.getGenericType(), field.getType(), enclosingType, false);
    }

    private static TypeTag resolve(Type type, Class<?> typeAsClass, TypeTag enclosingType, boolean shortCircuitRecursiveTypeBound) {
        ArrayList<TypeTag> nestedTags = new ArrayList<TypeTag>();
        if (type instanceof Class) {
            return TypeTag.processClass((Class)type, nestedTags);
        }
        if (type instanceof ParameterizedType) {
            return TypeTag.processParameterizedType((ParameterizedType)type, typeAsClass, enclosingType, nestedTags, shortCircuitRecursiveTypeBound);
        }
        if (type instanceof GenericArrayType) {
            return TypeTag.processGenericArray((GenericArrayType)type, typeAsClass, enclosingType);
        }
        if (type instanceof WildcardType) {
            return TypeTag.processWildcard((WildcardType)type, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound);
        }
        if (type instanceof TypeVariable) {
            return TypeTag.processTypeVariable((TypeVariable)type, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound);
        }
        throw new EqualsVerifierInternalBugException("Failed to tag type " + type.toString() + " (" + type.getClass() + ")");
    }

    private static TypeTag processClass(Class<?> type, List<TypeTag> nestedTags) {
        return new TypeTag(type, nestedTags);
    }

    private static TypeTag processParameterizedType(ParameterizedType type, Class<?> typeAsClass, TypeTag enclosingType, List<TypeTag> nestedTags, boolean shortCircuitRecursiveTypeBound) {
        Type[] typeArgs;
        for (Type typeArg : typeArgs = type.getActualTypeArguments()) {
            nestedTags.add(TypeTag.resolve(typeArg, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound));
        }
        return new TypeTag((Class)type.getRawType(), nestedTags);
    }

    private static TypeTag processGenericArray(GenericArrayType type, Class<?> typeAsClass, TypeTag enclosingType) {
        TypeTag tag = TypeTag.resolve(type.getGenericComponentType(), typeAsClass, enclosingType, false);
        String arrayTypeName = "[L" + tag.getType().getName() + ";";
        Class arrayType = Util.classForName(arrayTypeName);
        return new TypeTag(arrayType, tag.getGenericTypes());
    }

    private static TypeTag processWildcard(WildcardType type, Class<?> typeAsClass, TypeTag enclosingType, boolean shortCircuitRecursiveTypeBound) {
        int n = 0;
        Type[] typeArray = type.getLowerBounds();
        int n2 = typeArray.length;
        if (n < n2) {
            Type b = typeArray[n];
            return TypeTag.resolve(b, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound);
        }
        for (Type b : type.getUpperBounds()) {
            TypeTag upper = TypeTag.resolve(b, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound);
            if (Object.class.equals(upper.getType())) continue;
            return upper;
        }
        typeArray = typeAsClass.getTypeParameters();
        n2 = typeArray.length;
        for (n = 0; n < n2; ++n) {
            int n3 = 0;
            Type tv = typeArray[n];
            Type[] typeArray2 = tv.getBounds();
            int n4 = typeArray2.length;
            if (n3 >= n4) continue;
            Type b = typeArray2[n3];
            return TypeTag.resolve(b, typeAsClass, enclosingType, shortCircuitRecursiveTypeBound);
        }
        return new TypeTag(Object.class, new TypeTag[0]);
    }

    private static TypeTag processTypeVariable(TypeVariable<?> type, Class<?> typeAsClass, TypeTag enclosingType, boolean shortCircuitRecursiveTypeBound) {
        String typeVariableName;
        Map<String, TypeTag> typeVariableLookup = TypeTag.buildLookup(enclosingType);
        if (typeVariableLookup.containsKey(typeVariableName = type.getName())) {
            return typeVariableLookup.get(typeVariableName);
        }
        for (Type b : type.getBounds()) {
            if (shortCircuitRecursiveTypeBound) continue;
            return TypeTag.resolve(b, typeAsClass, enclosingType, true);
        }
        return new TypeTag(Object.class, new TypeTag[0]);
    }

    private static Map<String, TypeTag> buildLookup(TypeTag enclosingType) {
        TypeVariable<Class<T>>[] typeParameters = enclosingType.getType().getTypeParameters();
        HashMap<String, TypeTag> lookup = new HashMap<String, TypeTag>();
        if (enclosingType.getGenericTypes().size() == 0) {
            return lookup;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            String name = typeParameters[i].getName();
            TypeTag tag = enclosingType.getGenericTypes().get(i);
            lookup.put(name, tag);
        }
        return lookup;
    }

    public <T> Class<T> getType() {
        return this.type;
    }

    public List<TypeTag> getGenericTypes() {
        return Collections.unmodifiableList(this.genericTypes);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeTag)) {
            return false;
        }
        TypeTag other = (TypeTag)obj;
        return this.type.equals(other.type) && this.genericTypes.equals(other.genericTypes);
    }

    public int hashCode() {
        int result = 37;
        result = 59 * result + this.type.hashCode();
        result = 59 * result + this.genericTypes.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("");
        s.append(this.type.getSimpleName());
        if (this.genericTypes.size() >= 1) {
            s.append("<");
            s.append(this.genericTypes.get(0));
        }
        for (int i = 1; i < this.genericTypes.size(); ++i) {
            s.append(", ");
            s.append(this.genericTypes.get(i));
        }
        if (this.genericTypes.size() >= 1) {
            s.append(">");
        }
        return s.toString();
    }

    private static final class NullType {
        private NullType() {
        }
    }
}

