/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.vintage.prefabvalues.factories;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.instantiation.VintageValueProvider;
import nl.jqno.equalsverifier.internal.reflection.vintage.prefabvalues.factories.AbstractGenericFactory;

public class SimpleGenericFactory<T>
extends AbstractGenericFactory<T> {
    private final Func<T> factory;
    private final Supplier<T> emptyFactory;

    public SimpleGenericFactory(Func<T> factory, Supplier<T> emptyFactory) {
        this.factory = factory;
        this.emptyFactory = emptyFactory;
    }

    @Override
    public Tuple<T> createValues(TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
        LinkedHashSet<TypeTag> clone = this.cloneWith(typeStack, tag);
        ArrayList redValues = new ArrayList();
        ArrayList blueValues = new ArrayList();
        boolean useEmpty = false;
        int n = tag.getType().getTypeParameters().length;
        for (int i = 0; i < n; ++i) {
            Object blueValue;
            TypeTag paramTag = this.determineAndCacheActualTypeTag(i, tag, valueProvider, clone);
            Object redValue = valueProvider.giveRed(paramTag);
            if (redValue.equals(blueValue = valueProvider.giveBlue(paramTag))) {
                useEmpty = true;
            }
            redValues.add(redValue);
            blueValues.add(blueValue);
        }
        T red = this.factory.apply(redValues);
        T blue = useEmpty && this.emptyFactory != null ? this.emptyFactory.get() : this.factory.apply(blueValues);
        T redCopy = this.factory.apply(redValues);
        return Tuple.of(red, blue, redCopy);
    }
}

