/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.SuperclassIterable;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class CachedHashCodeInitializer<T> {
    private final boolean passthrough;
    private final Field cachedHashCodeField;
    private final Method calculateMethod;
    private final T example;

    private CachedHashCodeInitializer() {
        this(true, null, null, null);
    }

    private CachedHashCodeInitializer(boolean passthrough, Field cachedHashCodeField, Method calculateMethod, T example) {
        this.passthrough = passthrough;
        this.cachedHashCodeField = cachedHashCodeField;
        this.calculateMethod = calculateMethod;
        this.example = example;
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Will evaluate this later")
    public CachedHashCodeInitializer(Class<?> type, String cachedHashCodeField, String calculateHashCodeMethod, T example) {
        this.passthrough = false;
        this.cachedHashCodeField = CachedHashCodeInitializer.findCachedHashCodeField(type, cachedHashCodeField);
        this.calculateMethod = CachedHashCodeInitializer.findCalculateHashCodeMethod(type, calculateHashCodeMethod, false);
        this.example = example;
    }

    public static <T> CachedHashCodeInitializer<T> passthrough() {
        return new CachedHashCodeInitializer<T>();
    }

    public static <T> CachedHashCodeInitializer<T> lombokCachedHashcode(T example) {
        Class<?> type = example.getClass();
        return new CachedHashCodeInitializer<T>(false, CachedHashCodeInitializer.findCachedHashCodeField(type, "$hashCodeCache"), CachedHashCodeInitializer.findCalculateHashCodeMethod(type, "hashCode", true), example);
    }

    public boolean isPassthrough() {
        return this.passthrough;
    }

    public T getExample() {
        return this.example;
    }

    public String getCachedHashCodeFieldName() {
        if (this.isPassthrough()) {
            return null;
        }
        return this.cachedHashCodeField.getName();
    }

    public int getInitializedHashCode(Object object) {
        if (!this.passthrough) {
            this.recomputeCachedHashCode(object);
        }
        return object.hashCode();
    }

    private void recomputeCachedHashCode(Object object) {
        Rethrow.rethrow(() -> {
            this.cachedHashCodeField.set(object, 0);
            Integer recomputedHashCode = (Integer)this.calculateMethod.invoke(object, new Object[0]);
            this.cachedHashCodeField.set(object, recomputedHashCode);
        });
    }

    private static Field findCachedHashCodeField(Class<?> type, String cachedHashCodeFieldName) {
        for (Field candidateField : FieldIterable.of(type)) {
            if (!candidateField.getName().equals(cachedHashCodeFieldName) || Modifier.isPublic(candidateField.getModifiers()) || !candidateField.getType().equals(Integer.TYPE)) continue;
            candidateField.setAccessible(true);
            return candidateField;
        }
        throw new IllegalArgumentException("Cached hashCode: Could not find cachedHashCodeField: must be 'private int " + cachedHashCodeFieldName + ";'");
    }

    private static Method findCalculateHashCodeMethod(Class<?> type, String calculateHashCodeMethodName, boolean acceptPublicMethod) {
        for (Class<?> currentClass : SuperclassIterable.ofIncludeSelf(type)) {
            try {
                Method method = currentClass.getDeclaredMethod(calculateHashCodeMethodName, new Class[0]);
                if (!acceptPublicMethod && Modifier.isPublic(method.getModifiers()) || !method.getReturnType().equals(Integer.TYPE)) continue;
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new IllegalArgumentException("Cached hashCode: Could not find calculateHashCodeMethod: must be 'private int " + calculateHashCodeMethodName + "()'");
    }
}

