/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.reflection.FactoryCache;
import nl.jqno.equalsverifier.internal.reflection.FieldCache;
import nl.jqno.equalsverifier.internal.reflection.JavaApiPrefabValues;
import nl.jqno.equalsverifier.internal.reflection.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.reflection.instantiation.ValueProvider;
import nl.jqno.equalsverifier.internal.reflection.instantiation.VintageValueProvider;
import nl.jqno.equalsverifier.internal.util.Configuration;

public final class Context<T> {
    private final Class<T> type;
    private final Configuration<T> configuration;
    private final ClassProbe<T> classProbe;
    private final FieldCache fieldCache;
    private final SubjectCreator<T> subjectCreator;
    private final ValueProvider valueProvider;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="FieldCache is inherently mutable")
    public Context(Configuration<T> configuration, FactoryCache factoryCache, FieldCache fieldCache, Objenesis objenesis) {
        this.type = configuration.getType();
        this.configuration = configuration;
        this.classProbe = new ClassProbe<T>(configuration.getType());
        this.fieldCache = fieldCache;
        FactoryCache cache = JavaApiPrefabValues.build().merge(factoryCache);
        this.valueProvider = new VintageValueProvider(cache, objenesis);
        this.subjectCreator = new SubjectCreator<T>(configuration, this.valueProvider, fieldCache, objenesis);
    }

    public Class<T> getType() {
        return this.type;
    }

    public Configuration<T> getConfiguration() {
        return this.configuration;
    }

    public ClassProbe<T> getClassProbe() {
        return this.classProbe;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="A cache is inherently mutable")
    public FieldCache getFieldCache() {
        return this.fieldCache;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="VintageValueProvider can use a mutable cache.")
    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public SubjectCreator<T> getSubjectCreator() {
        return this.subjectCreator;
    }
}

