/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.versionspecific;

import java.lang.reflect.Modifier;
import java.util.Optional;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SealedTypesHelper {
    private SealedTypesHelper() {
    }

    public static boolean isSealed(Class<?> type) {
        return type.isSealed();
    }

    public static <T, U extends T> Optional<Class<U>> findInstantiableSubclass(Class<T> type) {
        return SealedTypesHelper.findInstantiablePermittedClass(type, false);
    }

    private static <T, U extends T> Optional<Class<U>> findInstantiablePermittedClass(Class<T> type, boolean checkCurrent) {
        if (!(!checkCurrent || SealedTypesHelper.isAbstract(type) && type.isSealed())) {
            Class<T> result = type;
            return Optional.of(result);
        }
        Class<?>[] permittedSubclasses = type.getPermittedSubclasses();
        if (permittedSubclasses == null) {
            return Optional.empty();
        }
        for (Class<?> permitted : permittedSubclasses) {
            Class<?> subType = permitted;
            Optional<Class<U>> c = SealedTypesHelper.findInstantiablePermittedClass(subType, true);
            if (!c.isPresent()) continue;
            return c;
        }
        throw new EqualsVerifierInternalBugException("Could not find a non-sealed subtype for " + type.getCanonicalName());
    }

    private static boolean isAbstract(Class<?> type) {
        return Modifier.isAbstract(type.getModifiers());
    }
}

