/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation;

import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.DoubleSummaryStatistics;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IntSummaryStatistics;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Queue;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factories.EnumMapFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factories.EnumSetFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factories.ExternalFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factories.Factories;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.reflection.ConditionalInstantiator;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.Util;
import nl.jqno.equalsverifier.internal.util.Rethrow;
import nl.jqno.equalsverifier.internal.versionspecific.SequencedCollectionsHelper;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="That would be dozens of separate classes")
public final class JavaApiPrefabValues {
    private static final String JAVAFX_COLLECTIONS_PACKAGE = "javafx.collections.";
    private static final String JAVAFX_PROPERTY_PACKAGE = "javafx.beans.property.";
    private static final String GUAVA_PACKAGE = "com.google.common.collect.";
    private static final String JODA_PACKAGE = "org.joda.time.";
    private static final ExternalFactory<?> AWT_FACTORY = new ExternalFactory("AwtFactoryProvider");
    private static final ExternalFactory<?> JAVAFX_FACTORY = new ExternalFactory("JavaFxFactoryProvider");
    private static final ExternalFactory<?> JAVAX_FACTORY = new ExternalFactory("JavaxFactoryProvider");
    private static final ExternalFactory<?> GUAVA_FACTORY = new ExternalFactory("GuavaFactoryProvider");
    private static final ExternalFactory<?> JODA_FACTORY = new ExternalFactory("JodaFactoryProvider");
    private static final ExternalFactory<?> RMI_FACTORY = new ExternalFactory("RmiFactoryProvider");
    private static final Comparator<Object> OBJECT_COMPARATOR = Comparator.comparingInt(Object::hashCode);
    private final FactoryCache factoryCache;

    private JavaApiPrefabValues(FactoryCache factoryCache) {
        this.factoryCache = factoryCache;
    }

    public static FactoryCache build() {
        FactoryCache result = new FactoryCache();
        new JavaApiPrefabValues(result).addJavaClasses();
        return result;
    }

    private void addJavaClasses() {
        this.addPrimitiveClasses();
        this.addCommonClasses();
        this.addDateTimeClasses();
        this.addUncommonClasses();
        this.addCollection();
        this.addLists();
        this.addMaps();
        this.addSets();
        this.addQueues();
        SequencedCollectionsHelper.add(this.factoryCache);
        this.addNioBuffers();
        this.addExceptions();
        this.addReflectionClasses();
        this.addAtomicClasses();
        this.addAncientJavaApiClasses();
        this.addJavaFxClasses();
        this.addJavaxApiClasses();
        this.addGoogleGuavaMultisetCollectionsClasses();
        this.addGoogleGuavaMultimapCollectionsClasses();
        this.addGoogleGuavaBiMapCollectionsClasses();
        this.addGoogleGuavaTableCollectionClasses();
        this.addGoogleGuavaRegularCollectionsClasses();
        this.addGoogleGuavaImmutableClasses();
        this.addNewGoogleGuavaClasses();
        this.addJodaTimeClasses();
    }

    @SuppressFBWarnings(value={"DM_BOOLEAN_CTOR", "DM_NUMBER_CTOR", "DM_FP_NUMBER_CTOR", "DM_STRING_CTOR"}, justification="We really do need a separate instances with the same value")
    private void addPrimitiveClasses() {
        this.addValues(Boolean.TYPE, true, false, true);
        this.addValues(Byte.TYPE, (byte)1, (byte)2, (byte)1);
        this.addValues(Character.TYPE, Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('a'));
        this.addValues(Double.TYPE, 0.5, 1.0, 0.5);
        this.addValues(Float.TYPE, Float.valueOf(0.5f), Float.valueOf(1.0f), Float.valueOf(0.5f));
        this.addValues(Integer.TYPE, 1, 2, 1);
        this.addValues(Long.TYPE, 1L, 2L, 1L);
        this.addValues(Short.TYPE, (short)1, (short)2, (short)1);
        this.addValues(Boolean.class, true, false, true);
        this.addValues(Byte.class, (byte)1, (byte)2, (byte)1);
        this.addValues(Character.class, Character.valueOf('\u03b1'), Character.valueOf('\u03c9'), Character.valueOf('\u03b1'));
        this.addValues(Double.class, 0.5, 1.0, 0.5);
        this.addValues(Float.class, Float.valueOf(0.5f), Float.valueOf(1.0f), Float.valueOf(0.5f));
        this.addValues(Integer.class, 1000, 2000, 1000);
        this.addValues(Long.class, 1000L, 2000L, 1000L);
        this.addValues(Short.class, (short)1000, (short)2000, (short)1000);
        this.addValues(Object.class, new Object(), new Object(), new Object());
        this.addValues(String.class, "one", "two", new String("one"));
        this.addValues(Enum.class, Dummy.RED, Dummy.BLUE, Dummy.RED);
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME", "DM_USELESS_THREAD"}, justification="We just need an instance of File and Thread; they're not for actual use.")
    private void addCommonClasses() {
        this.addValues(BigDecimal.class, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO);
        this.addValues(BigInteger.class, BigInteger.ZERO, BigInteger.ONE, BigInteger.ZERO);
        this.addValues(Charset.class, StandardCharsets.UTF_8, StandardCharsets.US_ASCII, StandardCharsets.UTF_8);
        this.addValues(File.class, new File(""), new File("/"), new File(""));
        this.addValues(Formatter.class, new Formatter(), new Formatter(), new Formatter());
        this.addValues(Locale.class, new Locale("nl"), new Locale("hu"), new Locale("nl"));
        this.addValues(Pattern.class, Pattern.compile("one"), Pattern.compile("two"), Pattern.compile("one"));
        this.addValues(Scanner.class, new Scanner("one"), new Scanner("two"), new Scanner("one"));
        this.addValues(StampedLock.class, new StampedLock(), new StampedLock(), new StampedLock());
        this.addValues(StringBuilder.class, new StringBuilder("one"), new StringBuilder("two"), new StringBuilder("three"));
        this.addValues(Thread.class, new Thread("one"), new Thread("two"), new Thread("one"));
        this.addValues(Throwable.class, new Throwable(), new Throwable(), new Throwable());
        this.addValues(URI.class, URI.create("x"), URI.create("y"), URI.create("x"));
        this.addValues(UUID.class, new UUID(0L, -1L), new UUID(1L, 0L), new UUID(0L, -1L));
        this.addValues(PrintStream.class, System.out, System.err, System.out);
        Rethrow.rethrow(() -> this.addValues(URL.class, new URL("http://example.com"), new URL("http://localhost"), new URL("http://example.com")), e -> "Can't add prefab values for java.net.URL");
        this.addFactory(CompletableFuture.class, Factories.simple(ignored -> new CompletableFuture(), CompletableFuture::new));
        this.addFactory(Optional.class, Factories.simple(Optional::of, Optional::empty));
        this.addValues(OptionalDouble.class, OptionalDouble.of(0.5), OptionalDouble.of(1.0), OptionalDouble.of(0.5));
        this.addValues(OptionalInt.class, OptionalInt.of(1), OptionalInt.of(2), OptionalInt.of(1));
        this.addValues(OptionalLong.class, OptionalLong.of(1L), OptionalLong.of(2L), OptionalLong.of(1L));
        this.addFactory(Supplier.class, Factories.simple(a -> () -> a, () -> () -> null));
        this.addValues(Currency.class, Currency.getInstance("USD"), Currency.getInstance("EUR"), Currency.getInstance("JPY"));
        Semaphore redSemaphore = new Semaphore(1);
        Semaphore blueSemaphore = new Semaphore(1);
        this.addValues(Semaphore.class, redSemaphore, blueSemaphore, redSemaphore);
        DoubleSummaryStatistics redDoubleStats = new DoubleSummaryStatistics();
        DoubleSummaryStatistics blueDoubleStats = new DoubleSummaryStatistics();
        this.addValues(DoubleSummaryStatistics.class, redDoubleStats, blueDoubleStats, redDoubleStats);
        IntSummaryStatistics redIntStats = new IntSummaryStatistics();
        IntSummaryStatistics blueIntStats = new IntSummaryStatistics();
        this.addValues(IntSummaryStatistics.class, redIntStats, blueIntStats, redIntStats);
        LongSummaryStatistics redLongStats = new LongSummaryStatistics();
        LongSummaryStatistics blueLongStats = new LongSummaryStatistics();
        this.addValues(LongSummaryStatistics.class, redLongStats, blueLongStats, redLongStats);
    }

    private void addDateTimeClasses() {
        this.addValues(Calendar.class, new GregorianCalendar(2010, 7, 4), new GregorianCalendar(2010, 7, 5), new GregorianCalendar(2010, 7, 4));
        this.addValues(Clock.class, Clock.systemUTC(), Clock.system(ZoneId.of("-10")), Clock.systemUTC());
        this.addValues(Date.class, new Date(0L), new Date(1L), new Date(0L));
        this.addValues(DateFormat.class, DateFormat.getTimeInstance(), DateFormat.getDateInstance(), DateFormat.getTimeInstance());
        this.addValues(DateTimeFormatter.class, DateTimeFormatter.ISO_TIME, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_TIME);
        this.addValues(Duration.class, Duration.ZERO, Duration.ofDays(1L), Duration.ZERO);
        this.addValues(GregorianCalendar.class, new GregorianCalendar(2010, 7, 4), new GregorianCalendar(2010, 7, 5), new GregorianCalendar(2010, 7, 4));
        this.addValues(Instant.class, Instant.MIN, Instant.MAX, Instant.MIN);
        this.addValues(LocalDateTime.class, LocalDateTime.MIN, LocalDateTime.MAX, LocalDateTime.MIN);
        this.addValues(LocalDate.class, LocalDate.MIN, LocalDate.MAX, LocalDate.MIN);
        this.addValues(LocalTime.class, LocalTime.MIN, LocalTime.MAX, LocalTime.MIN);
        this.addValues(MonthDay.class, MonthDay.of(1, 1), MonthDay.of(12, 31), MonthDay.of(1, 1));
        this.addValues(OffsetDateTime.class, OffsetDateTime.MIN, OffsetDateTime.MAX, OffsetDateTime.MIN);
        this.addValues(OffsetTime.class, OffsetTime.MIN, OffsetTime.MAX, OffsetTime.MIN);
        this.addValues(Period.class, Period.ZERO, Period.of(1, 1, 1), Period.ZERO);
        this.addValues(DecimalFormat.class, new DecimalFormat("x0.0"), new DecimalFormat("y0.0"), new DecimalFormat("x0.0"));
        this.addValues(NumberFormat.class, new DecimalFormat("x0.0"), new DecimalFormat("y0.0"), new DecimalFormat("x0.0"));
        this.addValues(SimpleDateFormat.class, new SimpleDateFormat("yMd"), new SimpleDateFormat("dMy"), new SimpleDateFormat("yMd"));
        this.addValues(TimeZone.class, TimeZone.getTimeZone("GMT+1"), TimeZone.getTimeZone("GMT+2"), TimeZone.getTimeZone("GMT+1"));
        this.addValues(Year.class, Year.of(2000), Year.of(2010), Year.of(2000));
        this.addValues(YearMonth.class, YearMonth.of(2000, 1), YearMonth.of(2010, 12), YearMonth.of(2000, 1));
        this.addValues(ZoneId.class, ZoneId.of("+1"), ZoneId.of("-10"), ZoneId.of("+1"));
        this.addValues(ZoneOffset.class, ZoneOffset.ofHours(1), ZoneOffset.ofHours(-1), ZoneOffset.ofHours(1));
        this.addValues(ZonedDateTime.class, ZonedDateTime.parse("2017-12-13T10:15:30+01:00"), ZonedDateTime.parse("2016-11-12T09:14:29-01:00"), ZonedDateTime.parse("2017-12-13T10:15:30+01:00"));
    }

    private void addUncommonClasses() {
        this.addFactory(ThreadLocal.class, Factories.simple(a -> ThreadLocal.withInitial(() -> a), null));
        ConditionalInstantiator sqlDate = new ConditionalInstantiator("java.sql.Date");
        ConditionalInstantiator sqlTime = new ConditionalInstantiator("java.sql.Time");
        ConditionalInstantiator sqlTimestamp = new ConditionalInstantiator("java.sql.Timestamp");
        this.addValues(sqlDate.resolve(), sqlDate.instantiate(Util.classes(Long.TYPE), Util.objects(1337)), sqlDate.instantiate(Util.classes(Long.TYPE), Util.objects(42)), sqlDate.instantiate(Util.classes(Long.TYPE), Util.objects(1337)));
        this.addValues(sqlTime.resolve(), sqlTime.instantiate(Util.classes(Long.TYPE), Util.objects(1337)), sqlTime.instantiate(Util.classes(Long.TYPE), Util.objects(42)), sqlTime.instantiate(Util.classes(Long.TYPE), Util.objects(1337)));
        this.addValues(sqlTimestamp.resolve(), sqlTimestamp.instantiate(Util.classes(Long.TYPE), Util.objects(1337)), sqlTimestamp.instantiate(Util.classes(Long.TYPE), Util.objects(42)), sqlTimestamp.instantiate(Util.classes(Long.TYPE), Util.objects(1337)));
        this.addValues(EventObject.class, new EventObject(1), new EventObject(2), new EventObject(1));
        this.addValues(InetSocketAddress.class, InetSocketAddress.createUnresolved("localhost", 8080), InetSocketAddress.createUnresolved("127.0.0.1", 8080), InetSocketAddress.createUnresolved("localhost", 8080));
        ConditionalInstantiator inetAddress = new ConditionalInstantiator("java.net.InetAddress");
        ConditionalInstantiator inet4Address = new ConditionalInstantiator("java.net.Inet4Address");
        ConditionalInstantiator inet6Address = new ConditionalInstantiator("java.net.Inet6Address");
        this.addValues(inetAddress.resolve(), inetAddress.callFactory("getByName", Util.classes(String.class), Util.objects("127.0.0.1")), inetAddress.callFactory("getByName", Util.classes(String.class), Util.objects("127.0.0.42")), inetAddress.callFactory("getByName", Util.classes(String.class), Util.objects("127.0.0.1")));
        this.addValues(inet4Address.resolve(), inet4Address.callFactory("getByName", Util.classes(String.class), Util.objects("127.0.0.1")), inet4Address.callFactory("getByName", Util.classes(String.class), Util.objects("127.0.0.42")), inet4Address.callFactory("getByName", Util.classes(String.class), Util.objects("127.0.0.1")));
        this.addValues(inet6Address.resolve(), inet6Address.callFactory("getByName", Util.classes(String.class), Util.objects("::1")), inet6Address.callFactory("getByName", Util.classes(String.class), Util.objects("::")), inet6Address.callFactory("getByName", Util.classes(String.class), Util.objects("::1")));
    }

    private void addCollection() {
        this.addFactory(Iterable.class, Factories.simple(a -> {
            ArrayList<Object> coll = new ArrayList<Object>();
            coll.add(a);
            return coll;
        }, ArrayList::new));
        this.addFactory(Collection.class, Factories.collection(ArrayList::new));
    }

    private void addLists() {
        this.addFactory(List.class, Factories.collection(ArrayList::new));
        this.addFactory(CopyOnWriteArrayList.class, Factories.collection(CopyOnWriteArrayList::new));
        this.addFactory(LinkedList.class, Factories.collection(LinkedList::new));
        this.addFactory(ArrayList.class, Factories.collection(ArrayList::new));
        this.addFactory(Vector.class, Factories.collection(Vector::new));
        this.addFactory(Stack.class, Factories.collection(Stack::new));
    }

    private void addMaps() {
        this.addFactory(Map.class, Factories.map(HashMap::new));
        this.addFactory(SortedMap.class, Factories.map(() -> new TreeMap(OBJECT_COMPARATOR)));
        this.addFactory(NavigableMap.class, Factories.map(() -> new TreeMap(OBJECT_COMPARATOR)));
        this.addFactory(ConcurrentNavigableMap.class, Factories.map(() -> new ConcurrentSkipListMap(OBJECT_COMPARATOR)));
        this.addFactory(ConcurrentHashMap.class, Factories.map(ConcurrentHashMap::new));
        this.addFactory(HashMap.class, Factories.map(HashMap::new));
        this.addFactory(Hashtable.class, Factories.map(Hashtable::new));
        this.addFactory(LinkedHashMap.class, Factories.map(LinkedHashMap::new));
        this.addFactory(Properties.class, Factories.map(Properties::new));
        this.addFactory(TreeMap.class, Factories.map(() -> new TreeMap(OBJECT_COMPARATOR)));
        this.addFactory(WeakHashMap.class, Factories.map(WeakHashMap::new));
        this.addFactory(EnumMap.class, new EnumMapFactory<EnumMap>(EnumMap::new));
    }

    private void addSets() {
        this.addFactory(Set.class, Factories.collection(HashSet::new));
        this.addFactory(SortedSet.class, Factories.collection(() -> new TreeSet<Object>(OBJECT_COMPARATOR)));
        this.addFactory(NavigableSet.class, Factories.collection(() -> new TreeSet<Object>(OBJECT_COMPARATOR)));
        this.addFactory(CopyOnWriteArraySet.class, Factories.collection(CopyOnWriteArraySet::new));
        this.addFactory(HashSet.class, Factories.collection(HashSet::new));
        this.addFactory(TreeSet.class, Factories.collection(() -> new TreeSet<Object>(OBJECT_COMPARATOR)));
        this.addFactory(EnumSet.class, new EnumSetFactory<EnumSet>(c -> EnumSet.copyOf(c)));
        this.addValues(BitSet.class, BitSet.valueOf(new byte[]{0}), BitSet.valueOf(new byte[]{1}), BitSet.valueOf(new byte[]{0}));
    }

    private void addQueues() {
        this.addFactory(Queue.class, Factories.collection(() -> new ArrayBlockingQueue(1)));
        this.addFactory(BlockingQueue.class, Factories.collection(() -> new ArrayBlockingQueue(1)));
        this.addFactory(Deque.class, Factories.collection(() -> new ArrayDeque(1)));
        this.addFactory(BlockingDeque.class, Factories.collection(() -> new LinkedBlockingDeque(1)));
        this.addFactory(ArrayBlockingQueue.class, Factories.collection(() -> new ArrayBlockingQueue(1)));
        this.addFactory(ConcurrentLinkedQueue.class, Factories.collection(ConcurrentLinkedQueue::new));
        this.addFactory(DelayQueue.class, Factories.collection(DelayQueue::new));
        this.addFactory(LinkedBlockingQueue.class, Factories.collection(() -> new LinkedBlockingQueue(1)));
        this.addFactory(PriorityBlockingQueue.class, Factories.collection(() -> new PriorityBlockingQueue<Object>(1, OBJECT_COMPARATOR)));
        this.addValues(SynchronousQueue.class, new SynchronousQueue(), new SynchronousQueue(), new SynchronousQueue());
    }

    private void addNioBuffers() {
        this.addValues(Buffer.class, ByteBuffer.wrap(new byte[]{0}), ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{0}));
        this.addValues(ByteBuffer.class, ByteBuffer.wrap(new byte[]{0}), ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{0}));
        this.addValues(CharBuffer.class, CharBuffer.wrap("a"), CharBuffer.wrap("b"), CharBuffer.wrap("a"));
        this.addValues(DoubleBuffer.class, DoubleBuffer.wrap(new double[]{0.0}), DoubleBuffer.wrap(new double[]{1.0}), DoubleBuffer.wrap(new double[]{0.0}));
        this.addValues(FloatBuffer.class, FloatBuffer.wrap(new float[]{0.0f}), FloatBuffer.wrap(new float[]{1.0f}), FloatBuffer.wrap(new float[]{0.0f}));
        this.addValues(IntBuffer.class, IntBuffer.wrap(new int[]{0}), IntBuffer.wrap(new int[]{1}), IntBuffer.wrap(new int[]{0}));
        this.addValues(LongBuffer.class, LongBuffer.wrap(new long[]{0L}), LongBuffer.wrap(new long[]{1L}), LongBuffer.wrap(new long[]{0L}));
        this.addValues(ShortBuffer.class, ShortBuffer.wrap(new short[]{0}), ShortBuffer.wrap(new short[]{1}), ShortBuffer.wrap(new short[]{0}));
    }

    private void addExceptions() {
        Throwable redThrowable = new Throwable();
        Throwable blueThrowable = new Throwable();
        this.addValues(Throwable.class, redThrowable, blueThrowable, redThrowable);
        Exception redException = new Exception();
        Exception blueException = new Exception();
        this.addValues(Exception.class, redException, blueException, redException);
        RuntimeException redRuntimeException = new RuntimeException();
        RuntimeException blueRuntimeException = new RuntimeException();
        this.addValues(RuntimeException.class, redRuntimeException, blueRuntimeException, redRuntimeException);
    }

    private void addReflectionClasses() {
        this.addValues(Class.class, Class.class, Object.class, Class.class);
        Rethrow.rethrow(() -> {
            Field f1 = JavaApiReflectionClassesContainer.class.getDeclaredField("a");
            Field f2 = JavaApiReflectionClassesContainer.class.getDeclaredField("b");
            this.addValues(Field.class, f1, f2, f1);
        }, e -> "Can't add prefab values for java.lang.reflect.Field");
        Rethrow.rethrow(() -> {
            Constructor c1 = JavaApiReflectionClassesContainer.class.getDeclaredConstructor(new Class[0]);
            Constructor c2 = JavaApiReflectionClassesContainer.class.getDeclaredConstructor(Object.class);
            this.addValues(Constructor.class, c1, c2, c1);
        }, e -> "Can't add prefab values for java.lang.reflect.Constructor");
        Rethrow.rethrow(() -> {
            Method m1 = JavaApiReflectionClassesContainer.class.getDeclaredMethod("m1", new Class[0]);
            Method m2 = JavaApiReflectionClassesContainer.class.getDeclaredMethod("m2", new Class[0]);
            this.addValues(Method.class, m1, m2, m1);
        }, e -> "Can't add prefab values for java.lang.reflect.Method");
    }

    private void addAtomicClasses() {
        this.addValues(AtomicBoolean.class, new AtomicBoolean(true), new AtomicBoolean(false), new AtomicBoolean(true));
        this.addValues(AtomicInteger.class, new AtomicInteger(1), new AtomicInteger(2), new AtomicInteger(1));
        this.addValues(AtomicIntegerArray.class, new AtomicIntegerArray(new int[]{1}), new AtomicIntegerArray(new int[]{2}), new AtomicIntegerArray(new int[]{1}));
        this.addValues(AtomicLong.class, new AtomicLong(1L), new AtomicLong(2L), new AtomicLong(1L));
        this.addValues(AtomicLongArray.class, new AtomicLongArray(new long[]{1L}), new AtomicLongArray(new long[]{2L}), new AtomicLongArray(new long[]{1L}));
        this.addFactory(AtomicMarkableReference.class, Factories.simple(r -> new AtomicMarkableReference<Object>(r, true), null));
        this.addFactory(AtomicReference.class, Factories.simple(AtomicReference::new, null));
        this.addFactory(AtomicStampedReference.class, Factories.simple(r -> new AtomicStampedReference<Object>(r, 0), null));
        this.addFactory(AtomicReferenceArray.class, (tag, pv, stack) -> {
            TypeTag y = tag.getGenericTypes().get(0);
            Object[] red = new Object[]{pv.giveRed(y)};
            Object[] blue = new Object[]{pv.giveBlue(y)};
            Object[] redCopy = new Object[]{pv.giveRedCopy(y)};
            return Tuple.of(new AtomicReferenceArray<Object>(red), new AtomicReferenceArray<Object>(blue), new AtomicReferenceArray<Object>(redCopy));
        });
        DoubleAdder redDoubleAdder = new DoubleAdder();
        DoubleAdder blueDoubleAdder = new DoubleAdder();
        this.addValues(DoubleAdder.class, redDoubleAdder, blueDoubleAdder, redDoubleAdder);
        DoubleAccumulator redDoubleAccumulator = new DoubleAccumulator((a, b) -> a + b, 0.0);
        DoubleAccumulator blueDoubleAccumulator = new DoubleAccumulator((a, b) -> a * b, 1.0);
        this.addValues(DoubleAccumulator.class, redDoubleAccumulator, blueDoubleAccumulator, redDoubleAccumulator);
        LongAdder redLongAdder = new LongAdder();
        LongAdder blueLongAdder = new LongAdder();
        this.addValues(LongAdder.class, redLongAdder, blueLongAdder, redLongAdder);
        LongAccumulator redLongAccumulator = new LongAccumulator((a, b) -> a + b, 0L);
        LongAccumulator blueLongAccumulator = new LongAccumulator((a, b) -> a * b, 1L);
        this.addValues(LongAccumulator.class, redLongAccumulator, blueLongAccumulator, redLongAccumulator);
    }

    private void addAncientJavaApiClasses() {
        this.addLazyFactory("java.awt.Color", AWT_FACTORY);
        this.addLazyFactory("java.awt.color.ColorSpace", AWT_FACTORY);
        this.addLazyFactory("java.awt.color.ICC_ColorSpace", AWT_FACTORY);
        this.addLazyFactory("java.awt.color.ICC_Profile", AWT_FACTORY);
        this.addLazyFactory("java.awt.Font", AWT_FACTORY);
        this.addLazyFactory("java.awt.Image", AWT_FACTORY);
        this.addFactory(PropertyChangeSupport.class, Factories.values(new PropertyChangeSupport("this"), new PropertyChangeSupport("that"), new PropertyChangeSupport("this")));
        this.addLazyFactory("java.rmi.dgc.VMID", RMI_FACTORY);
        this.addLazyFactory("java.rmi.server.UID", RMI_FACTORY);
    }

    private void addJavaFxClasses() {
        this.addLazyFactory("javafx.collections.ObservableList", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.collections.ObservableMap", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.collections.ObservableSet", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.BooleanProperty", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.DoubleProperty", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.FloatProperty", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.IntegerProperty", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.ListProperty", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.LongProperty", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.MapProperty", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.ObjectProperty", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.SetProperty", JAVAFX_FACTORY);
        this.addLazyFactory("javafx.beans.property.StringProperty", JAVAFX_FACTORY);
    }

    private void addJavaxApiClasses() {
        this.addLazyFactory("javax.naming.Reference", JAVAX_FACTORY);
        this.addLazyFactory("javax.swing.tree.DefaultMutableTreeNode", JAVAX_FACTORY);
    }

    private void addGoogleGuavaMultisetCollectionsClasses() {
        this.addLazyFactory("com.google.common.collect.Multiset", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.SortedMultiset", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.HashMultiset", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.TreeMultiset", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.LinkedHashMultiset", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ConcurrentHashMultiset", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.EnumMultiset", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableMultiset", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableSortedMultiset", GUAVA_FACTORY);
    }

    private void addGoogleGuavaMultimapCollectionsClasses() {
        this.addLazyFactory("com.google.common.collect.Multimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ListMultimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.SetMultimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.SortedSetMultimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ArrayListMultimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.HashMultimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.LinkedListMultimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.LinkedHashMultimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.TreeMultimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableListMultimap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableSetMultimap", GUAVA_FACTORY);
    }

    private void addGoogleGuavaBiMapCollectionsClasses() {
        this.addLazyFactory("com.google.common.collect.BiMap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.HashBiMap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.EnumHashBiMap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableBiMap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.EnumBiMap", GUAVA_FACTORY);
    }

    private void addGoogleGuavaTableCollectionClasses() {
        this.addLazyFactory("com.google.common.collect.Table", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.HashBasedTable", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.TreeBasedTable", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ArrayTable", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableTable", GUAVA_FACTORY);
    }

    private void addGoogleGuavaRegularCollectionsClasses() {
        this.addLazyFactory("com.google.common.collect.EvictingQueue", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.MinMaxPriorityQueue", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableRangeSet", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.TreeRangeSet", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.RangeSet", GUAVA_FACTORY);
    }

    private void addGoogleGuavaImmutableClasses() {
        this.addLazyFactory("com.google.common.collect.ImmutableCollection", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableList", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableMap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableSet", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableSortedMap", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.collect.ImmutableSortedSet", GUAVA_FACTORY);
    }

    private void addNewGoogleGuavaClasses() {
        this.addLazyFactory("com.google.common.collect.Range", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.base.Optional", GUAVA_FACTORY);
        this.addLazyFactory("com.google.common.reflect.TypeToken", GUAVA_FACTORY);
    }

    private void addJodaTimeClasses() {
        this.addLazyFactory("org.joda.time.Chronology", JODA_FACTORY);
        this.addLazyFactory("org.joda.time.DateTimeZone", JODA_FACTORY);
        this.addLazyFactory("org.joda.time.PeriodType", JODA_FACTORY);
        this.addLazyFactory("org.joda.time.YearMonth", JODA_FACTORY);
        this.addLazyFactory("org.joda.time.MonthDay", JODA_FACTORY);
    }

    private <T> void addValues(Class<T> type, T red, T blue, T redCopy) {
        this.factoryCache.put(type, Factories.values(red, blue, redCopy));
    }

    private <T> void addFactory(Class<T> type, PrefabValueFactory<T> factory) {
        this.factoryCache.put(type, factory);
    }

    private <T> void addLazyFactory(String typeName, PrefabValueFactory<T> factory) {
        this.factoryCache.put(typeName, factory);
    }

    private static enum Dummy {
        RED,
        BLUE;

    }

    private static class JavaApiReflectionClassesContainer {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="These fields are accessed through reflection")
        Object a;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="These fields are accessed through reflection")
        Object b;

        public JavaApiReflectionClassesContainer() {
        }

        public JavaApiReflectionClassesContainer(Object o) {
        }

        void m1() {
        }

        void m2() {
        }
    }
}

