/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factoryproviders;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import nl.jqno.equalsverifier.internal.instantiation.vintage.FactoryCache;
import nl.jqno.equalsverifier.internal.instantiation.vintage.VintageValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factories.AbstractGenericFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factories.Factories;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.instantiation.vintage.prefabvalues.factoryproviders.FactoryProvider;
import nl.jqno.equalsverifier.internal.reflection.ConditionalInstantiator;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.Util;

public final class JavaFxFactoryProvider
implements FactoryProvider {
    private static final String JAVAFX_COLLECTIONS_PACKAGE = "javafx.collections.";
    private static final String JAVAFX_PROPERTY_PACKAGE = "javafx.beans.property.";

    @Override
    public FactoryCache getFactoryCache() {
        FactoryCache cache = new FactoryCache();
        cache.put("javafx.collections.ObservableList", JavaFxFactoryProvider.fxCollection(List.class, "observableList"));
        cache.put("javafx.collections.ObservableMap", JavaFxFactoryProvider.fxCollection(Map.class, "observableMap"));
        cache.put("javafx.collections.ObservableSet", JavaFxFactoryProvider.fxCollection(Set.class, "observableSet"));
        cache.put("javafx.beans.property.BooleanProperty", this.fxProperty("SimpleBooleanProperty", Boolean.TYPE));
        cache.put("javafx.beans.property.DoubleProperty", this.fxProperty("SimpleDoubleProperty", Double.TYPE));
        cache.put("javafx.beans.property.FloatProperty", this.fxProperty("SimpleFloatProperty", Float.TYPE));
        cache.put("javafx.beans.property.IntegerProperty", this.fxProperty("SimpleIntegerProperty", Integer.TYPE));
        cache.put("javafx.beans.property.ListProperty", this.fxProperty("SimpleListProperty", Util.classForName("javafx.collections.ObservableList")));
        cache.put("javafx.beans.property.LongProperty", this.fxProperty("SimpleLongProperty", Long.TYPE));
        cache.put("javafx.beans.property.MapProperty", this.fxProperty("SimpleMapProperty", Util.classForName("javafx.collections.ObservableMap")));
        cache.put("javafx.beans.property.ObjectProperty", this.fxProperty("SimpleObjectProperty", Object.class));
        cache.put("javafx.beans.property.SetProperty", this.fxProperty("SimpleSetProperty", Util.classForName("javafx.collections.ObservableSet")));
        cache.put("javafx.beans.property.StringProperty", this.fxProperty("SimpleStringProperty", String.class));
        return cache;
    }

    private <T> PrefabValueFactory<T> fxProperty(String typeName, Class<?> parameterRawType) {
        return new PropertyFactory(JAVAFX_PROPERTY_PACKAGE + typeName, parameterRawType);
    }

    private static <T, S> PrefabValueFactory<T> fxCollection(Class<S> source, String copyMethodName) {
        Function<Object, Object> f = a -> new ConditionalInstantiator("javafx.collections.FXCollections").callFactory(copyMethodName, Util.classes(source), Util.objects(a));
        return Factories.copy(source, f);
    }

    static final class PropertyFactory<T>
    extends AbstractGenericFactory<T> {
        private final String fullyQualifiedTypeName;
        private final Class<?> parameterRawType;

        PropertyFactory(String fullyQualifiedTypeName, Class<?> parameterRawType) {
            this.fullyQualifiedTypeName = fullyQualifiedTypeName;
            this.parameterRawType = parameterRawType;
        }

        @Override
        public Tuple<T> createValues(TypeTag tag, VintageValueProvider valueProvider, LinkedHashSet<TypeTag> typeStack) {
            ConditionalInstantiator ci = new ConditionalInstantiator(this.fullyQualifiedTypeName);
            TypeTag singleParameterTag = this.copyGenericTypesInto(this.parameterRawType, tag);
            Object red = ci.instantiate(Util.classes(this.parameterRawType), Util.objects(valueProvider.giveRed(singleParameterTag)));
            Object blue = ci.instantiate(Util.classes(this.parameterRawType), Util.objects(valueProvider.giveBlue(singleParameterTag)));
            Object redCopy = ci.instantiate(Util.classes(this.parameterRawType), Util.objects(valueProvider.giveRed(singleParameterTag)));
            return Tuple.of(red, blue, redCopy);
        }
    }
}

