/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.reflection.SuperclassIterable;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class CachedHashCodeInitializer<T> {
    private final boolean passthrough;
    private final FieldProbe cachedHashCodeField;
    private final Method calculateMethod;
    private final T example;

    private CachedHashCodeInitializer() {
        this(true, null, null, null);
    }

    private CachedHashCodeInitializer(boolean passthrough, FieldProbe cachedHashCodeField, Method calculateMethod, T example) {
        this.passthrough = passthrough;
        this.cachedHashCodeField = cachedHashCodeField;
        this.calculateMethod = calculateMethod;
        this.example = example;
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Will evaluate this later")
    public CachedHashCodeInitializer(Class<?> type, String cachedHashCodeField, String calculateHashCodeMethod, T example) {
        this.passthrough = false;
        this.cachedHashCodeField = CachedHashCodeInitializer.findCachedHashCodeField(type, cachedHashCodeField);
        this.calculateMethod = CachedHashCodeInitializer.findCalculateHashCodeMethod(type, calculateHashCodeMethod, false);
        this.example = example;
    }

    public static <T> CachedHashCodeInitializer<T> passthrough() {
        return new CachedHashCodeInitializer<T>();
    }

    public static <T> CachedHashCodeInitializer<T> lombokCachedHashcode(T example) {
        Class<?> type = example.getClass();
        return new CachedHashCodeInitializer<T>(false, CachedHashCodeInitializer.findCachedHashCodeField(type, "$hashCodeCache"), CachedHashCodeInitializer.findCalculateHashCodeMethod(type, "hashCode", true), example);
    }

    public boolean isPassthrough() {
        return this.passthrough;
    }

    public T getExample() {
        return this.example;
    }

    public String getCachedHashCodeFieldName() {
        if (this.isPassthrough()) {
            return null;
        }
        return this.cachedHashCodeField.getName();
    }

    public int getInitializedHashCode(Object object) {
        if (!this.passthrough) {
            this.recomputeCachedHashCode(object);
        }
        return object.hashCode();
    }

    private void recomputeCachedHashCode(Object object) {
        Rethrow.rethrow(() -> {
            Field f = this.cachedHashCodeField.getField();
            f.setAccessible(true);
            f.set(object, 0);
            Integer recomputedHashCode = (Integer)this.calculateMethod.invoke(object, new Object[0]);
            f.set(object, recomputedHashCode);
        });
    }

    private static FieldProbe findCachedHashCodeField(Class<?> type, String cachedHashCodeFieldName) {
        for (FieldProbe candidate : FieldIterable.of(type)) {
            if (!candidate.getName().equals(cachedHashCodeFieldName) || candidate.isPublic() || !candidate.getType().equals(Integer.TYPE)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Cached hashCode: Could not find cachedHashCodeField: must be 'private int " + cachedHashCodeFieldName + ";'");
    }

    private static Method findCalculateHashCodeMethod(Class<?> type, String calculateHashCodeMethodName, boolean acceptPublicMethod) {
        for (Class<?> currentClass : SuperclassIterable.ofIncludeSelf(type)) {
            try {
                Method method = currentClass.getDeclaredMethod(calculateHashCodeMethodName, new Class[0]);
                if (!acceptPublicMethod && Modifier.isPublic(method.getModifiers()) || !method.getReturnType().equals(Integer.TYPE)) continue;
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new IllegalArgumentException("Cached hashCode: Could not find calculateHashCodeMethod: must be 'private int " + calculateHashCodeMethodName + "()'");
    }
}

