/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.reflection.ClassProbe;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Context;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class SignatureChecker<T>
implements Checker {
    private final Class<T> type;
    private final ClassProbe<T> classProbe;
    private final Set<Warning> warningsToSuppress;

    public SignatureChecker(Context<T> context) {
        this.type = context.getType();
        this.classProbe = context.getClassProbe();
        this.warningsToSuppress = context.getConfiguration().getWarningsToSuppress();
    }

    @Override
    public void check() {
        List<Method> equalsMethods = this.getEqualsMethods();
        if (equalsMethods.size() > 1) {
            this.failOverloaded("More than one equals method found");
        }
        if (equalsMethods.size() == 1) {
            this.checkEquals(equalsMethods.get(0));
        }
        this.checkEqualsIsDefined();
    }

    private List<Method> getEqualsMethods() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.type.getDeclaredMethods()) {
            if (!"equals".equals(method.getName()) || Modifier.isStatic(method.getModifiers())) continue;
            result.add(method);
        }
        return result;
    }

    private void failOverloaded(String message) {
        Assert.fail(Formatter.of("Overloaded: %%.\nSignature should be: public boolean equals(Object obj)", message));
    }

    private void checkEquals(Method equals) {
        Class<?> parameterType;
        Class<?>[] parameterTypes = equals.getParameterTypes();
        if (parameterTypes.length > 1) {
            this.failOverloaded("Too many parameters");
        }
        if (parameterTypes.length == 0) {
            this.failOverloaded("No parameter");
        }
        if ((parameterType = parameterTypes[0]) == this.type) {
            this.failOverloaded("Parameter should be an Object, not " + this.type.getSimpleName());
        }
        if (parameterType != Object.class) {
            this.failOverloaded("Parameter should be an Object");
        }
    }

    private void checkEqualsIsDefined() {
        boolean dontAllowDirectlyInherited = !this.warningsToSuppress.contains((Object)Warning.INHERITED_DIRECTLY_FROM_OBJECT);
        boolean isDirectlyInherited = this.classProbe.isEqualsInheritedFromObject();
        if (dontAllowDirectlyInherited && isDirectlyInherited) {
            Assert.fail(Formatter.of("Equals is inherited directly from Object.\nSuppress Warning." + Warning.INHERITED_DIRECTLY_FROM_OBJECT.name() + " to skip this check.", new Object[0]));
        }
    }
}

