/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.util.regex.Matcher;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;

public final class Formatter {
    private final String message;
    private final Object[] objects;

    private Formatter(String message, Object ... objects) {
        if (message == null) {
            throw new NullPointerException();
        }
        this.message = message;
        this.objects = objects;
    }

    public static Formatter of(String message, Object ... objects) {
        return new Formatter(message, objects);
    }

    public String format() {
        String result = this.message;
        for (Object object : this.objects) {
            String s = result.replaceFirst("%%", Matcher.quoteReplacement(this.stringify(object)));
            if (result.equals(s)) {
                throw new IllegalStateException("Too many parameters");
            }
            result = s;
        }
        if (result.contains("%%")) {
            throw new IllegalStateException("Not enough parameters");
        }
        return result;
    }

    private String stringify(Object obj) {
        if (obj == null) {
            return "null";
        }
        try {
            return obj.toString();
        }
        catch (AbstractMethodError e) {
            return this.stringifyByReflection(obj);
        }
        catch (Throwable e) {
            return this.stringifyByReflection(obj) + "-throws " + e.getClass().getSimpleName() + "(" + e.getMessage() + ")";
        }
    }

    private String stringifyByReflection(Object obj) {
        StringBuilder result = new StringBuilder();
        Class<?> type = obj.getClass();
        result.append("[");
        String typeName = type.getSimpleName().replaceAll("\\$\\$DynamicSubclass.*", "");
        result.append(typeName);
        boolean foundFields = false;
        for (FieldProbe probe : FieldIterable.of(type)) {
            foundFields = true;
            String fieldName = probe.getName();
            result.append(" ");
            result.append(fieldName);
            result.append("=");
            Object value = probe.getValue(obj);
            result.append(this.stringify(value));
        }
        if (!foundFields) {
            result.append(" (no fields)");
        }
        result.append("]");
        return result.toString();
    }
}

