/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.ScanOption;
import nl.jqno.equalsverifier.internal.reflection.PackageScanOptions;

final class ScanOptions {
    private ScanOptions() {
    }

    public static PackageScanOptions process(ScanOption ... options) {
        PackageScanOptions result = new PackageScanOptions();
        for (ScanOption option : options) {
            if (option.equals(O.RECURSIVE)) {
                result.scanRecursively = true;
            }
            if (option.equals(O.IGNORE_EXTERNAL_JARS)) {
                result.ignoreExternalJars = true;
            }
            if (option instanceof MustExtend) {
                MustExtend me = (MustExtend)option;
                result.mustExtend = me.type;
            }
            if (option instanceof ExceptClasses) {
                ExceptClasses ec = (ExceptClasses)option;
                result.exceptClasses.addAll(ec.types);
            }
            if (!(option instanceof ExclusionPredicate)) continue;
            ExclusionPredicate ep = (ExclusionPredicate)option;
            result.exclusionPredicate = ep.exclusionPredicate;
        }
        return result;
    }

    static enum O implements ScanOption
    {
        RECURSIVE,
        IGNORE_EXTERNAL_JARS;

    }

    static class MustExtend
    implements ScanOption {
        final Class<?> type;

        MustExtend(Class<?> type) {
            Objects.requireNonNull(type);
            this.type = type;
        }
    }

    static class ExceptClasses
    implements ScanOption {
        final Set<Class<?>> types = new HashSet();

        ExceptClasses(Class<?> type, Class<?> ... more) {
            this.types.add(type);
            this.types.addAll(Arrays.asList(more));
        }
    }

    static class ExclusionPredicate
    implements ScanOption {
        final Predicate<Class<?>> exclusionPredicate;

        ExclusionPredicate(Predicate<Class<?>> exclusionPredicate) {
            this.exclusionPredicate = exclusionPredicate;
        }
    }
}

