/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.List;
import nl.jqno.equalsverifier.CheckReturnValue;
import nl.jqno.equalsverifier.ConfiguredEqualsVerifier;
import nl.jqno.equalsverifier.ScanOption;
import nl.jqno.equalsverifier.ScanOptions;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.api.MultipleTypeEqualsVerifierApi;
import nl.jqno.equalsverifier.api.RelaxedEqualsVerifierApi;
import nl.jqno.equalsverifier.api.SingleTypeEqualsVerifierApi;
import nl.jqno.equalsverifier.internal.reflection.PackageScanOptions;
import nl.jqno.equalsverifier.internal.reflection.PackageScanner;
import nl.jqno.equalsverifier.internal.util.ListBuilders;
import nl.jqno.equalsverifier.internal.util.Validations;

public final class EqualsVerifier {
    private EqualsVerifier() {
    }

    @CheckReturnValue
    public static ConfiguredEqualsVerifier configure() {
        return new ConfiguredEqualsVerifier();
    }

    @CheckReturnValue
    public static ConfiguredEqualsVerifier simple() {
        return new ConfiguredEqualsVerifier().suppress(Warning.STRICT_INHERITANCE, Warning.NONFINAL_FIELDS);
    }

    @CheckReturnValue
    public static <T> SingleTypeEqualsVerifierApi<T> forClass(Class<T> type) {
        return new SingleTypeEqualsVerifierApi<T>(type);
    }

    @CheckReturnValue
    public static MultipleTypeEqualsVerifierApi forClasses(Iterable<Class<?>> classes) {
        return new MultipleTypeEqualsVerifierApi(ListBuilders.fromIterable(classes), new ConfiguredEqualsVerifier());
    }

    @CheckReturnValue
    public static MultipleTypeEqualsVerifierApi forClasses(Class<?> first, Class<?> second, Class<?> ... more) {
        return new MultipleTypeEqualsVerifierApi(ListBuilders.buildListOfAtLeastTwo(first, second, more), new ConfiguredEqualsVerifier());
    }

    @CheckReturnValue
    public static MultipleTypeEqualsVerifierApi forPackage(String packageName, ScanOption ... options) {
        PackageScanOptions opts = ScanOptions.process(options);
        List<Class<?>> classes = PackageScanner.getClassesIn(packageName, opts);
        Validations.validatePackageContainsClasses(packageName, classes);
        return new MultipleTypeEqualsVerifierApi(classes, new ConfiguredEqualsVerifier());
    }

    @Deprecated
    @CheckReturnValue
    public static MultipleTypeEqualsVerifierApi forPackage(String packageName, boolean scanRecursively) {
        return scanRecursively ? EqualsVerifier.forPackage(packageName, ScanOption.recursive()) : EqualsVerifier.forPackage(packageName, new ScanOption[0]);
    }

    @Deprecated
    @CheckReturnValue
    public static MultipleTypeEqualsVerifierApi forPackage(String packageName, Class<?> mustExtend) {
        PackageScanOptions opts = ScanOptions.process(ScanOption.recursive(), ScanOption.mustExtend(mustExtend));
        List<Class<?>> classes = PackageScanner.getClassesIn(packageName, opts);
        Validations.validatePackageContainsClasses(packageName, classes);
        return new MultipleTypeEqualsVerifierApi(classes, new ConfiguredEqualsVerifier());
    }

    @SafeVarargs
    @CheckReturnValue
    public static <T> RelaxedEqualsVerifierApi<T> forRelaxedEqualExamples(T first, T second, T ... more) {
        List<T> examples = ListBuilders.buildListOfAtLeastTwo(first, second, more);
        Class<?> type = first.getClass();
        return new RelaxedEqualsVerifierApi(type, examples);
    }
}

