/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.instantiation.vintage.reflection;

import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.instantiation.vintage.VintageValueProvider;
import nl.jqno.equalsverifier.internal.instantiation.vintage.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;

public class ClassAccessor<T> {
    private final Class<T> type;
    private final VintageValueProvider valueProvider;
    private final Objenesis objenesis;

    ClassAccessor(Class<T> type, VintageValueProvider valueProvider, Objenesis objenesis) {
        this.type = type;
        this.valueProvider = valueProvider;
        this.objenesis = objenesis;
    }

    public static <T> ClassAccessor<T> of(Class<T> type, VintageValueProvider valueProvider, Objenesis objenesis) {
        return new ClassAccessor<T>(type, valueProvider, objenesis);
    }

    public T getRedObject(TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack) {
        return this.getRedAccessor(enclosingType, typeStack).get();
    }

    public ObjectAccessor<T> getRedAccessor(TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack) {
        return this.buildObjectAccessor().scramble(this.valueProvider, enclosingType, typeStack);
    }

    public T getBlueObject(TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack) {
        return this.getBlueAccessor(enclosingType, typeStack).get();
    }

    public ObjectAccessor<T> getBlueAccessor(TypeTag enclosingType, LinkedHashSet<TypeTag> typeStack) {
        return this.buildObjectAccessor().scramble(this.valueProvider, enclosingType, typeStack).scramble(this.valueProvider, enclosingType, typeStack);
    }

    private ObjectAccessor<T> buildObjectAccessor() {
        T object = Instantiator.of(this.type, this.objenesis).instantiate();
        return ObjectAccessor.of(object);
    }
}

