/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.internal.reflection.Tuple;
import nl.jqno.equalsverifier.internal.reflection.TypeTag;

public class FieldCache {
    private final Map<Key, Tuple<?>> cache = new HashMap();

    public <T> void put(String fieldName, TypeTag fieldType, Tuple<T> tuple) {
        if (fieldName != null && fieldType != null) {
            this.cache.put(new Key(fieldName, fieldType), tuple);
        }
    }

    public <T> Tuple<T> get(String fieldName, TypeTag fieldType) {
        if (fieldName == null || fieldType == null) {
            return null;
        }
        return this.cache.get(new Key(fieldName, fieldType));
    }

    public boolean contains(String fieldName, TypeTag fieldType) {
        return this.cache.containsKey(new Key(fieldName, fieldType));
    }

    public Set<String> getFieldNames() {
        return new HashSet<String>(this.cache.keySet().stream().map(key -> ((Key)key).fieldName).collect(Collectors.toSet()));
    }

    static class Key {
        private final String fieldName;
        private final TypeTag fieldType;

        public Key(String fieldName, TypeTag fieldType) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.fieldType, other.fieldType);
        }

        public int hashCode() {
            return Objects.hash(this.fieldName, this.fieldType);
        }
    }
}

