/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import nl.jqno.equalsverifier.internal.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.instantiation.SubjectCreator;
import nl.jqno.equalsverifier.internal.reflection.FieldProbe;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class SymmetryFieldCheck<T>
implements FieldCheck<T> {
    private final SubjectCreator<T> subjectCreator;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="PrefabValues is inherently mutable.")
    public SymmetryFieldCheck(SubjectCreator<T> subjectCreator) {
        this.subjectCreator = subjectCreator;
    }

    @Override
    public void execute(FieldProbe fieldProbe) {
        T left = this.subjectCreator.plain();
        T right = this.subjectCreator.plain();
        T changedRight = this.subjectCreator.withFieldChanged(fieldProbe.getField());
        this.checkSymmetry(left, right);
        this.checkSymmetry(left, changedRight);
    }

    private void checkSymmetry(T left, T right) {
        Assert.assertTrue(Formatter.of("Symmetry: objects are not symmetric:\n  %%\nand\n  %%", left, right), left.equals(right) == right.equals(left));
    }
}

